/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input.internal;

import androidx.annotation.VisibleForTesting;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.StringHelpers_commonStubsKt;
import androidx.compose.foundation.text.input.TextFieldBuffer;
import androidx.compose.foundation.text.input.TextFieldBufferKt;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u001c\u0010\b\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\f\u0010\r\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u001c\u0010\u000e\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0000\u001a\u001c\u0010\u0011\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0000\u001a\f\u0010\u0012\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a\u001c\u0010\u0013\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0001\u001a$\u0010\u0016\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0017H\u0001\u001a\u001c\u0010\u0018\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0000\u001a8\u0010\u0019\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u001a\b\u0002\u0010\u001a\u001a\u0014\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001d0\u001cj\u0002`\u001e\u0018\u00010\u001bH\u0000\u001a\u001c\u0010\u001f\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0000\u00a8\u0006 "}, d2={"isSurrogatePair", "", "high", "", "low", "backspace", "", "Landroidx/compose/foundation/text/input/TextFieldBuffer;", "commitText", "text", "", "newCursorPosition", "", "deleteAll", "deleteSurroundingText", "lengthBeforeCursor", "lengthAfterCursor", "deleteSurroundingTextInCodePoints", "finishComposingText", "imeDelete", "start", "end", "imeReplace", "", "setComposingRegion", "setComposingText", "annotations", "", "Landroidx/compose/ui/text/AnnotatedString$Range;", "Landroidx/compose/ui/text/AnnotatedString$Annotation;", "Landroidx/compose/foundation/text/input/PlacedAnnotation;", "setSelection", "foundation"})
@SourceDebugExtension(value={"SMAP\nEditCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCommand.kt\nandroidx/compose/foundation/text/input/internal/EditCommandKt\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 MathUtils.kt\nandroidx/compose/foundation/text/input/internal/MathUtilsKt\n*L\n1#1,380:1\n96#2,5:381\n96#2,5:393\n25#3,3:386\n32#3,4:389\n*S KotlinDebug\n*F\n+ 1 EditCommand.kt\nandroidx/compose/foundation/text/input/internal/EditCommandKt\n*L\n164#1:381,5\n198#1:393,5\n171#1:386,3\n176#1:389,4\n*E\n"})
public final class EditCommandKt {
    public static final void commitText(@NotNull TextFieldBuffer $this$commitText, @NotNull String text, int newCursorPosition) {
        TextRange compositionRange = $this$commitText.getComposition-MzsxiRA$foundation();
        if (compositionRange != null) {
            EditCommandKt.imeReplace($this$commitText, TextRange.getStart-impl((long)compositionRange.unbox-impl()), TextRange.getEnd-impl((long)compositionRange.unbox-impl()), text);
        } else {
            EditCommandKt.imeReplace($this$commitText, TextRange.getStart-impl((long)$this$commitText.getSelection-d9O1mEE()), TextRange.getEnd-impl((long)$this$commitText.getSelection-d9O1mEE()), text);
        }
        int newCursor = TextRange.getStart-impl((long)$this$commitText.getSelection-d9O1mEE());
        int newCursorInBuffer = newCursorPosition > 0 ? newCursor + newCursorPosition - 1 : newCursor + newCursorPosition - text.length();
        $this$commitText.setSelection-5zc-tL8(TextRangeKt.TextRange((int)RangesKt.coerceIn((int)newCursorInBuffer, (int)0, (int)$this$commitText.getLength())));
    }

    public static final void setComposingRegion(@NotNull TextFieldBuffer $this$setComposingRegion, int start, int end) {
        int clampedEnd;
        int clampedStart;
        if ($this$setComposingRegion.hasComposition$foundation()) {
            $this$setComposingRegion.commitComposition$foundation();
        }
        if ((clampedStart = RangesKt.coerceIn((int)start, (int)0, (int)$this$setComposingRegion.getLength())) != (clampedEnd = RangesKt.coerceIn((int)end, (int)0, (int)$this$setComposingRegion.getLength()))) {
            if (clampedStart < clampedEnd) {
                TextFieldBuffer.setComposition$foundation$default($this$setComposingRegion, clampedStart, clampedEnd, null, 4, null);
            } else {
                TextFieldBuffer.setComposition$foundation$default($this$setComposingRegion, clampedEnd, clampedStart, null, 4, null);
            }
        }
    }

    public static final void setComposingText(@NotNull TextFieldBuffer $this$setComposingText, @NotNull String text, int newCursorPosition, @Nullable List<AnnotatedString.Range<AnnotatedString.Annotation>> annotations) {
        TextRange compositionRange = $this$setComposingText.getComposition-MzsxiRA$foundation();
        if (compositionRange != null) {
            EditCommandKt.imeReplace($this$setComposingText, TextRange.getStart-impl((long)compositionRange.unbox-impl()), TextRange.getEnd-impl((long)compositionRange.unbox-impl()), text);
            if (((CharSequence)text).length() > 0) {
                $this$setComposingText.setComposition$foundation(TextRange.getStart-impl((long)compositionRange.unbox-impl()), TextRange.getStart-impl((long)compositionRange.unbox-impl()) + text.length(), annotations);
            }
        } else {
            int initialSelectionStart = TextRange.getStart-impl((long)$this$setComposingText.getSelection-d9O1mEE());
            EditCommandKt.imeReplace($this$setComposingText, initialSelectionStart, TextRange.getEnd-impl((long)$this$setComposingText.getSelection-d9O1mEE()), text);
            if (((CharSequence)text).length() > 0) {
                $this$setComposingText.setComposition$foundation(initialSelectionStart, initialSelectionStart + text.length(), annotations);
            }
        }
        int newCursor = TextRange.getStart-impl((long)$this$setComposingText.getSelection-d9O1mEE());
        int newCursorInBuffer = newCursorPosition > 0 ? newCursor + newCursorPosition - 1 : newCursor + newCursorPosition - text.length();
        $this$setComposingText.setSelection-5zc-tL8(TextRangeKt.TextRange((int)RangesKt.coerceIn((int)newCursorInBuffer, (int)0, (int)$this$setComposingText.getLength())));
    }

    public static /* synthetic */ void setComposingText$default(TextFieldBuffer textFieldBuffer, String string, int n, List list, int n2, Object object) {
        if ((n2 & 4) != 0) {
            list = null;
        }
        EditCommandKt.setComposingText(textFieldBuffer, string, n, list);
    }

    public static final void deleteSurroundingText(@NotNull TextFieldBuffer $this$deleteSurroundingText, int lengthBeforeCursor, int lengthAfterCursor) {
        int n;
        int n2;
        boolean value$iv = lengthBeforeCursor >= 0 && lengthAfterCursor >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + lengthBeforeCursor + " and " + lengthAfterCursor + " respectively.");
        }
        int $this$addExactOrElse$iv = TextRange.getEnd-impl((long)$this$deleteSurroundingText.getSelection-d9O1mEE());
        boolean $i$f$addExactOrElse = false;
        int result$iv = $this$addExactOrElse$iv + lengthAfterCursor;
        if ((($this$addExactOrElse$iv ^ result$iv) & (lengthAfterCursor ^ result$iv)) < 0) {
            boolean bl = false;
            n2 = $this$deleteSurroundingText.getLength();
        } else {
            n2 = result$iv;
        }
        int end = n2;
        EditCommandKt.imeDelete($this$deleteSurroundingText, TextRange.getEnd-impl((long)$this$deleteSurroundingText.getSelection-d9O1mEE()), Math.min(end, $this$deleteSurroundingText.getLength()));
        int $this$subtractExactOrElse$iv = TextRange.getStart-impl((long)$this$deleteSurroundingText.getSelection-d9O1mEE());
        boolean $i$f$subtractExactOrElse = false;
        int result$iv2 = $this$subtractExactOrElse$iv - lengthBeforeCursor;
        if ((($this$subtractExactOrElse$iv ^ lengthBeforeCursor) & ($this$subtractExactOrElse$iv ^ result$iv2)) < 0) {
            boolean bl = false;
            n = 0;
        } else {
            n = result$iv2;
        }
        int start = n;
        EditCommandKt.imeDelete($this$deleteSurroundingText, Math.max(0, start), TextRange.getStart-impl((long)$this$deleteSurroundingText.getSelection-d9O1mEE()));
    }

    public static final void deleteSurroundingTextInCodePoints(@NotNull TextFieldBuffer $this$deleteSurroundingTextInCodePoints, int lengthBeforeCursor, int lengthAfterCursor) {
        boolean value$iv = lengthBeforeCursor >= 0 && lengthAfterCursor >= 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("Expected lengthBeforeCursor and lengthAfterCursor to be non-negative, were " + lengthBeforeCursor + " and " + lengthAfterCursor + " respectively.");
        }
        int beforeLenInChars = 0;
        for (int i = 0; i < lengthBeforeCursor; ++i) {
            if (TextRange.getStart-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()) > ++beforeLenInChars) {
                char trail;
                char lead = $this$deleteSurroundingTextInCodePoints.asCharSequence().charAt(TextRange.getStart-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()) - beforeLenInChars - 1);
                if (!EditCommandKt.isSurrogatePair(lead, trail = $this$deleteSurroundingTextInCodePoints.asCharSequence().charAt(TextRange.getStart-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()) - beforeLenInChars))) continue;
                ++beforeLenInChars;
                continue;
            }
            beforeLenInChars = TextRange.getStart-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE());
            break;
        }
        int afterLenInChars = 0;
        for (int i = 0; i < lengthAfterCursor; ++i) {
            if (TextRange.getEnd-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()) + ++afterLenInChars < $this$deleteSurroundingTextInCodePoints.getLength()) {
                char trail;
                char lead = $this$deleteSurroundingTextInCodePoints.asCharSequence().charAt(TextRange.getEnd-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()) + afterLenInChars - 1);
                if (!EditCommandKt.isSurrogatePair(lead, trail = $this$deleteSurroundingTextInCodePoints.asCharSequence().charAt(TextRange.getEnd-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()) + afterLenInChars))) continue;
                ++afterLenInChars;
                continue;
            }
            afterLenInChars = $this$deleteSurroundingTextInCodePoints.getLength() - TextRange.getEnd-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE());
            break;
        }
        EditCommandKt.imeDelete($this$deleteSurroundingTextInCodePoints, TextRange.getEnd-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()), TextRange.getEnd-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()) + afterLenInChars);
        EditCommandKt.imeDelete($this$deleteSurroundingTextInCodePoints, TextRange.getStart-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()) - beforeLenInChars, TextRange.getStart-impl((long)$this$deleteSurroundingTextInCodePoints.getSelection-d9O1mEE()));
    }

    public static final void finishComposingText(@NotNull TextFieldBuffer $this$finishComposingText) {
        $this$finishComposingText.commitComposition$foundation();
    }

    public static final void backspace(@NotNull TextFieldBuffer $this$backspace) {
        TextRange compositionRange = $this$backspace.getComposition-MzsxiRA$foundation();
        if (compositionRange != null) {
            EditCommandKt.imeDelete($this$backspace, TextRange.getStart-impl((long)compositionRange.unbox-impl()), TextRange.getEnd-impl((long)compositionRange.unbox-impl()));
        } else if ($this$backspace.hasSelection()) {
            int delStart = TextRange.getStart-impl((long)$this$backspace.getSelection-d9O1mEE());
            int delEnd = TextRange.getEnd-impl((long)$this$backspace.getSelection-d9O1mEE());
            $this$backspace.setSelection-5zc-tL8(TextRangeKt.TextRange((int)TextRange.getStart-impl((long)$this$backspace.getSelection-d9O1mEE())));
            EditCommandKt.imeDelete($this$backspace, delStart, delEnd);
        } else if (TextRange.getCollapsed-impl((long)$this$backspace.getSelection-d9O1mEE()) && TextRange.getStart-impl((long)$this$backspace.getSelection-d9O1mEE()) > 0) {
            int prevCursorPos = StringHelpers_commonStubsKt.findPrecedingBreak($this$backspace.toString(), TextRange.getStart-impl((long)$this$backspace.getSelection-d9O1mEE()));
            EditCommandKt.imeDelete($this$backspace, prevCursorPos, TextRange.getStart-impl((long)$this$backspace.getSelection-d9O1mEE()));
        }
    }

    public static final void deleteAll(@NotNull TextFieldBuffer $this$deleteAll) {
        EditCommandKt.imeReplace($this$deleteAll, 0, $this$deleteAll.getLength(), "");
    }

    public static final void setSelection(@NotNull TextFieldBuffer $this$setSelection, int start, int end) {
        int clampedStart = RangesKt.coerceIn((int)start, (int)0, (int)$this$setSelection.getLength());
        int clampedEnd = RangesKt.coerceIn((int)end, (int)0, (int)$this$setSelection.getLength());
        $this$setSelection.setSelection-5zc-tL8(TextRangeKt.TextRange((int)clampedStart, (int)clampedEnd));
    }

    private static final boolean isSurrogatePair(char high, char low) {
        return Character.isHighSurrogate(high) && Character.isLowSurrogate(low);
    }

    @VisibleForTesting
    public static final void imeReplace(@NotNull TextFieldBuffer $this$imeReplace, int start, int end, @NotNull CharSequence text) {
        int cMax;
        int cMin;
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        int i = 0;
        for (cMin = min; cMin < max && i < text.length() && text.charAt(i) == $this$imeReplace.asCharSequence().charAt(cMin); ++i, ++cMin) {
        }
        int j = text.length();
        for (cMax = max; cMax > cMin && j > i && text.charAt(j - 1) == $this$imeReplace.asCharSequence().charAt(cMax - 1); --j, --cMax) {
        }
        if (cMin != cMax || i != j) {
            $this$imeReplace.replace(cMin, cMax, text.subSequence(i, j));
        }
        $this$imeReplace.setSelection-5zc-tL8(TextRangeKt.TextRange((int)(min + text.length())));
    }

    @VisibleForTesting
    public static final void imeDelete(@NotNull TextFieldBuffer $this$imeDelete, int start, int end) {
        block2: {
            TextRange initialComposition = $this$imeDelete.getComposition-MzsxiRA$foundation();
            int min = Math.min(start, end);
            int max = Math.max(start, end);
            TextFieldBufferKt.delete($this$imeDelete, min, max);
            TextRange textRange2 = initialComposition;
            if (textRange2 == null) break block2;
            long it = textRange2.unbox-impl();
            boolean bl = false;
            long adjustedComposition = TextFieldBufferKt.adjustTextRange-vJH6DeI(initialComposition.unbox-impl(), min, max, 0);
            if (TextRange.getCollapsed-impl((long)adjustedComposition)) {
                $this$imeDelete.commitComposition$foundation();
            } else {
                TextFieldBuffer.setComposition$foundation$default($this$imeDelete, TextRange.getMin-impl((long)adjustedComposition), TextRange.getMax-impl((long)adjustedComposition), null, 4, null);
            }
        }
    }
}

