/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.collection.LongIntMap;
import androidx.collection.LongObjectMap;
import androidx.collection.LongObjectMapKt;
import androidx.collection.MutableLongObjectMap;
import androidx.compose.foundation.internal.InlineClassHelperKt;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\u0006\u0010,\u001a\u00020\rH\u0016J\u001c\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020.00H\u0016J\u0010\u00101\u001a\u00020\b2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u0000H\u0002J\u0012\u00106\u001a\u00020\u000b2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u0016J\u0018\u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\u000bH\u0002J\u0018\u0010:\u001a\u00020\b2\u0006\u00108\u001a\u00020\b2\u0006\u0010;\u001a\u00020\u000bH\u0002J\b\u0010<\u001a\u00020=H\u0016J2\u0010>\u001a\u00020.*\b\u0012\u0004\u0012\u00020\r0?2\u0006\u0010,\u001a\u00020\r2\u0006\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\bH\u0002R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0014\u0010'\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0019\u00a8\u0006C"}, d2={"Landroidx/compose/foundation/text/selection/MultiSelectionLayout;", "Landroidx/compose/foundation/text/selection/SelectionLayout;", "selectableIdToInfoListIndex", "Landroidx/collection/LongIntMap;", "infoList", "", "Landroidx/compose/foundation/text/selection/SelectableInfo;", "startSlot", "", "endSlot", "isStartHandle", "", "previousSelection", "Landroidx/compose/foundation/text/selection/Selection;", "(Landroidx/collection/LongIntMap;Ljava/util/List;IIZLandroidx/compose/foundation/text/selection/Selection;)V", "crossStatus", "Landroidx/compose/foundation/text/selection/CrossStatus;", "getCrossStatus", "()Landroidx/compose/foundation/text/selection/CrossStatus;", "currentInfo", "getCurrentInfo", "()Landroidx/compose/foundation/text/selection/SelectableInfo;", "endInfo", "getEndInfo", "getEndSlot", "()I", "firstInfo", "getFirstInfo", "getInfoList", "()Ljava/util/List;", "()Z", "lastInfo", "getLastInfo", "getPreviousSelection", "()Landroidx/compose/foundation/text/selection/Selection;", "getSelectableIdToInfoListIndex", "()Landroidx/collection/LongIntMap;", "size", "getSize", "startInfo", "getStartInfo", "getStartSlot", "createSubSelections", "Landroidx/collection/LongObjectMap;", "selection", "forEachMiddleInfo", "", "block", "Lkotlin/Function1;", "getInfoListIndexBySelectableId", "id", "", "shouldAnyInfoRecomputeSelection", "other", "shouldRecomputeSelection", "slotToIndex", "slot", "isMinimumSlot", "startOrEndSlotToIndex", "isStartSlot", "toString", "", "createAndPutSubSelection", "Landroidx/collection/MutableLongObjectMap;", "info", "minOffset", "maxOffset", "foundation"})
@SourceDebugExtension(value={"SMAP\nSelectionLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n+ 2 InlineClassHelper.kt\nandroidx/compose/foundation/internal/InlineClassHelperKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,762:1\n50#2,5:763\n50#2,5:768\n50#2,5:774\n1#3:773\n70#4,6:779\n*S KotlinDebug\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n*L\n148#1:763,5\n225#1:768,5\n265#1:774,5\n282#1:779,6\n*E\n"})
final class MultiSelectionLayout
implements SelectionLayout {
    @NotNull
    private final LongIntMap selectableIdToInfoListIndex;
    @NotNull
    private final List<SelectableInfo> infoList;
    private final int startSlot;
    private final int endSlot;
    private final boolean isStartHandle;
    @Nullable
    private final Selection previousSelection;

    public MultiSelectionLayout(@NotNull LongIntMap selectableIdToInfoListIndex, @NotNull List<SelectableInfo> infoList, int startSlot, int endSlot, boolean isStartHandle, @Nullable Selection previousSelection) {
        this.selectableIdToInfoListIndex = selectableIdToInfoListIndex;
        this.infoList = infoList;
        this.startSlot = startSlot;
        this.endSlot = endSlot;
        this.isStartHandle = isStartHandle;
        this.previousSelection = previousSelection;
        boolean value$iv = this.infoList.size() > 1;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("MultiSelectionLayout requires an infoList size greater than 1, was " + this.infoList.size() + ".");
        }
    }

    @NotNull
    public final LongIntMap getSelectableIdToInfoListIndex() {
        return this.selectableIdToInfoListIndex;
    }

    @NotNull
    public final List<SelectableInfo> getInfoList() {
        return this.infoList;
    }

    @Override
    public int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public int getEndSlot() {
        return this.endSlot;
    }

    @Override
    public boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Override
    @Nullable
    public Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @Override
    public int getSize() {
        return this.infoList.size();
    }

    @Override
    @NotNull
    public CrossStatus getCrossStatus() {
        return this.getStartSlot() < this.getEndSlot() ? CrossStatus.NOT_CROSSED : (this.getStartSlot() > this.getEndSlot() ? CrossStatus.CROSSED : this.infoList.get(this.getStartSlot() / 2).getRawCrossStatus());
    }

    @Override
    @NotNull
    public SelectableInfo getStartInfo() {
        return this.infoList.get(this.startOrEndSlotToIndex(this.getStartSlot(), true));
    }

    @Override
    @NotNull
    public SelectableInfo getEndInfo() {
        return this.infoList.get(this.startOrEndSlotToIndex(this.getEndSlot(), false));
    }

    @Override
    @NotNull
    public SelectableInfo getCurrentInfo() {
        return this.isStartHandle() ? this.getStartInfo() : this.getEndInfo();
    }

    @Override
    @NotNull
    public SelectableInfo getFirstInfo() {
        return this.getCrossStatus() == CrossStatus.CROSSED ? this.getEndInfo() : this.getStartInfo();
    }

    @Override
    @NotNull
    public SelectableInfo getLastInfo() {
        return this.getCrossStatus() == CrossStatus.CROSSED ? this.getStartInfo() : this.getEndInfo();
    }

    @Override
    public void forEachMiddleInfo(@NotNull Function1<? super SelectableInfo, Unit> block) {
        int maxIndex;
        int minIndex = this.getInfoListIndexBySelectableId(this.getFirstInfo().getSelectableId());
        if (minIndex + 1 >= (maxIndex = this.getInfoListIndexBySelectableId(this.getLastInfo().getSelectableId()))) {
            return;
        }
        for (int i = minIndex + 1; i < maxIndex; ++i) {
            block.invoke((Object)this.infoList.get(i));
        }
    }

    @Override
    public boolean shouldRecomputeSelection(@Nullable SelectionLayout other) {
        return this.getPreviousSelection() == null || other == null || !(other instanceof MultiSelectionLayout) || this.isStartHandle() != other.isStartHandle() || this.getStartSlot() != other.getStartSlot() || this.getEndSlot() != other.getEndSlot() || this.shouldAnyInfoRecomputeSelection((MultiSelectionLayout)other);
    }

    private final boolean shouldAnyInfoRecomputeSelection(MultiSelectionLayout other) {
        if (this.getSize() != other.getSize()) {
            return true;
        }
        int n = ((Collection)this.infoList).size();
        for (int i = 0; i < n; ++i) {
            SelectableInfo otherInfo;
            SelectableInfo thisInfo = this.infoList.get(i);
            if (!thisInfo.shouldRecomputeSelection(otherInfo = other.infoList.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public LongObjectMap<Selection> createSubSelections(@NotNull Selection selection) {
        LongObjectMap longObjectMap;
        if (selection.getStart().getSelectableId() == selection.getEnd().getSelectableId()) {
            boolean value$iv = selection.getHandlesCrossed() && selection.getStart().getOffset() >= selection.getEnd().getOffset() || !selection.getHandlesCrossed() && selection.getStart().getOffset() <= selection.getEnd().getOffset();
            boolean $i$f$checkPrecondition = false;
            if (!value$iv) {
                boolean bl = false;
                InlineClassHelperKt.throwIllegalStateException("unexpectedly miss-crossed selection: " + selection);
            }
            longObjectMap = LongObjectMapKt.longObjectMapOf((long)selection.getStart().getSelectableId(), (Object)selection);
        } else {
            MutableLongObjectMap mutableLongObjectMap;
            MutableLongObjectMap $this$createSubSelections_u24lambda_u244 = mutableLongObjectMap = LongObjectMapKt.mutableLongObjectMapOf();
            boolean bl = false;
            Selection $this$createSubSelections_u24lambda_u244_u24lambda_u242 = selection;
            boolean bl2 = false;
            Selection.AnchorInfo minAnchor = $this$createSubSelections_u24lambda_u244_u24lambda_u242.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u244_u24lambda_u242.getEnd() : $this$createSubSelections_u24lambda_u244_u24lambda_u242.getStart();
            this.createAndPutSubSelection((MutableLongObjectMap<Selection>)$this$createSubSelections_u24lambda_u244, selection, this.getFirstInfo(), minAnchor.getOffset(), this.getFirstInfo().getTextLength());
            this.forEachMiddleInfo((Function1<? super SelectableInfo, Unit>)((Function1)new Function1<SelectableInfo, Unit>(this, (MutableLongObjectMap<Selection>)$this$createSubSelections_u24lambda_u244, selection){
                final /* synthetic */ MultiSelectionLayout this$0;
                final /* synthetic */ MutableLongObjectMap<Selection> $this_apply;
                final /* synthetic */ Selection $selection;
                {
                    this.this$0 = $receiver;
                    this.$this_apply = $receiver2;
                    this.$selection = $selection;
                    super(1);
                }

                public final void invoke(SelectableInfo info) {
                    MultiSelectionLayout.access$createAndPutSubSelection(this.this$0, this.$this_apply, this.$selection, info, 0, info.getTextLength());
                }
            }));
            Selection $this$createSubSelections_u24lambda_u244_u24lambda_u243 = selection;
            boolean bl3 = false;
            Selection.AnchorInfo maxAnchor = $this$createSubSelections_u24lambda_u244_u24lambda_u243.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u244_u24lambda_u243.getStart() : $this$createSubSelections_u24lambda_u244_u24lambda_u243.getEnd();
            this.createAndPutSubSelection((MutableLongObjectMap<Selection>)$this$createSubSelections_u24lambda_u244, selection, this.getLastInfo(), 0, maxAnchor.getOffset());
            longObjectMap = (LongObjectMap)mutableLongObjectMap;
        }
        return longObjectMap;
    }

    private final void createAndPutSubSelection(MutableLongObjectMap<Selection> $this$createAndPutSubSelection, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        Selection subSelection = selection.getHandlesCrossed() ? info.makeSingleLayoutSelection(maxOffset, minOffset) : info.makeSingleLayoutSelection(minOffset, maxOffset);
        boolean value$iv = minOffset <= maxOffset;
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalStateException("minOffset should be less than or equal to maxOffset: " + subSelection);
        }
        $this$createAndPutSubSelection.put(info.getSelectableId(), (Object)subSelection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$fastForEachIndexed$iv;
        void $this$toString_u24lambda_u247;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        CrossStatus crossStatus = this.getCrossStatus();
        float f = (float)(this.getEndSlot() + 1) / (float)2;
        float f2 = (float)(this.getStartSlot() + 1) / (float)2;
        boolean bl = this.isStartHandle();
        boolean bl2 = false;
        $this$toString_u24lambda_u247.append("[\n\t");
        boolean first = false;
        first = true;
        List<SelectableInfo> list = this.infoList;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void info;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            SelectableInfo selectableInfo = (SelectableInfo)item$iv;
            int index2 = index$iv;
            boolean bl3 = false;
            if (first) {
                first = false;
            } else {
                $this$toString_u24lambda_u247.append(",\n\t");
            }
            $this$toString_u24lambda_u247.append(index2 + 1 + " -> " + (SelectableInfo)info);
        }
        $this$toString_u24lambda_u247.append("\n]");
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "MultiSelectionLayout(isStartHandle=" + bl + ", startPosition=" + f2 + ", endPosition=" + f + ", crossed=" + crossStatus + ", infos=" + string + ")";
    }

    private final int startOrEndSlotToIndex(int slot, boolean isStartSlot) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCrossStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = isStartSlot;
                break;
            }
            case 3: {
                if (!isStartSlot) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.slotToIndex(slot, bl);
    }

    private final int slotToIndex(int slot, boolean isMinimumSlot) {
        int slotAdjustment = isMinimumSlot ? 0 : 1;
        return (slot - slotAdjustment) / 2;
    }

    private final int getInfoListIndexBySelectableId(long id) {
        int n;
        try {
            n = this.selectableIdToInfoListIndex.get(id);
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Invalid selectableId: " + id, e);
        }
        return n;
    }

    public static final /* synthetic */ void access$createAndPutSubSelection(MultiSelectionLayout $this, MutableLongObjectMap $receiver, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        $this.createAndPutSubSelection((MutableLongObjectMap<Selection>)$receiver, selection, info, minOffset, maxOffset);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CrossStatus.values().length];
            try {
                nArray[CrossStatus.COLLAPSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossStatus.NOT_CROSSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CrossStatus.CROSSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

