/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Share: ImageVector
    get() {
        if (_share != null) {
            return _share!!
        }
        _share = materialIcon(name = "Rounded.Share") {
            materialPath {
                moveTo(18.0f, 16.0f)
                curveToRelative(-0.79f, 0.0f, -1.5f, 0.31f, -2.03f, 0.81f)
                lineTo(8.91f, 12.7f)
                curveTo(8.96f, 12.47f, 9.0f, 12.24f, 9.0f, 12.0f)
                reflectiveCurveToRelative(-0.04f, -0.47f, -0.09f, -0.7f)
                lineToRelative(7.05f, -4.11f)
                curveTo(16.49f, 7.69f, 17.21f, 8.0f, 18.0f, 8.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                curveToRelative(0.0f, 0.24f, 0.04f, 0.48f, 0.09f, 0.7f)
                lineTo(8.04f, 9.81f)
                curveTo(7.5f, 9.31f, 6.79f, 9.0f, 6.0f, 9.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                curveToRelative(0.79f, 0.0f, 1.5f, -0.31f, 2.04f, -0.81f)
                lineToRelative(7.05f, 4.12f)
                curveTo(15.04f, 18.53f, 15.0f, 18.76f, 15.0f, 19.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveTo(19.66f, 16.0f, 18.0f, 16.0f)
                close()
            }
        }
        return _share!!
    }

private var _share: ImageVector? = null
