/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Airlines: ImageVector
    get() {
        if (_airlines != null) {
            return _airlines!!
        }
        _airlines = materialIcon(name = "Filled.Airlines") {
            materialPath {
                moveTo(13.0f, 4.0f)
                lineTo(2.0f, 20.0f)
                horizontalLineToRelative(17.0f)
                lineToRelative(3.0f, -16.0f)
                horizontalLineTo(13.0f)
                close()
                moveTo(14.5f, 14.0f)
                curveToRelative(-1.38f, 0.0f, -2.5f, -1.12f, -2.5f, -2.5f)
                curveToRelative(0.0f, -1.38f, 1.12f, -2.5f, 2.5f, -2.5f)
                reflectiveCurveToRelative(2.5f, 1.12f, 2.5f, 2.5f)
                curveTo(17.0f, 12.88f, 15.88f, 14.0f, 14.5f, 14.0f)
                close()
            }
        }
        return _airlines!!
    }

private var _airlines: ImageVector? = null
