/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.DatasetLinked: ImageVector
    get() {
        if (_datasetLinked != null) {
            return _datasetLinked!!
        }
        _datasetLinked = materialIcon(name = "Filled.DatasetLinked") {
            materialPath {
                moveTo(8.09f, 17.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(3.69f)
                curveToRelative(0.95f, -0.63f, 2.09f, -1.0f, 3.31f, -1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.34f, 0.0f, 0.67f, 0.04f, 1.0f, 0.09f)
                verticalLineTo(5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(3.81f)
                curveTo(8.3f, 20.12f, 8.0f, 19.09f, 8.0f, 18.0f)
                curveTo(8.0f, 17.66f, 8.04f, 17.33f, 8.09f, 17.0f)
                close()
                moveTo(13.0f, 7.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(7.0f, 7.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(7.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 18.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                curveTo(12.9f, 20.0f, 12.0f, 19.1f, 12.0f, 18.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 14.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                curveTo(24.0f, 15.79f, 22.21f, 14.0f, 20.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(14.0f, 17.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-6.0f)
                close()
            }
        }
        return _datasetLinked!!
    }

private var _datasetLinked: ImageVector? = null
