/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.DoNotTouch: ImageVector
    get() {
        if (_doNotTouch != null) {
            return _doNotTouch!!
        }
        _doNotTouch = materialIcon(name = "Filled.DoNotTouch") {
            materialPath {
                moveTo(13.0f, 10.17f)
                lineToRelative(-2.5f, -2.5f)
                verticalLineTo(2.25f)
                curveTo(10.5f, 1.56f, 11.06f, 1.0f, 11.75f, 1.0f)
                reflectiveCurveTo(13.0f, 1.56f, 13.0f, 2.25f)
                verticalLineTo(10.17f)
                close()
                moveTo(20.0f, 12.75f)
                verticalLineTo(11.0f)
                verticalLineTo(5.25f)
                curveTo(20.0f, 4.56f, 19.44f, 4.0f, 18.75f, 4.0f)
                reflectiveCurveTo(17.5f, 4.56f, 17.5f, 5.25f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(3.25f)
                curveTo(16.5f, 2.56f, 15.94f, 2.0f, 15.25f, 2.0f)
                reflectiveCurveTo(14.0f, 2.56f, 14.0f, 3.25f)
                verticalLineToRelative(7.92f)
                lineToRelative(6.0f, 6.0f)
                verticalLineTo(12.75f)
                close()
                moveTo(9.5f, 4.25f)
                curveTo(9.5f, 3.56f, 8.94f, 3.0f, 8.25f, 3.0f)
                curveToRelative(-0.67f, 0.0f, -1.2f, 0.53f, -1.24f, 1.18f)
                lineTo(9.5f, 6.67f)
                verticalLineTo(4.25f)
                close()
                moveTo(13.0f, 10.17f)
                lineToRelative(-2.5f, -2.5f)
                verticalLineTo(2.25f)
                curveTo(10.5f, 1.56f, 11.06f, 1.0f, 11.75f, 1.0f)
                reflectiveCurveTo(13.0f, 1.56f, 13.0f, 2.25f)
                verticalLineTo(10.17f)
                close()
                moveTo(20.0f, 12.75f)
                verticalLineTo(11.0f)
                verticalLineTo(5.25f)
                curveTo(20.0f, 4.56f, 19.44f, 4.0f, 18.75f, 4.0f)
                reflectiveCurveTo(17.5f, 4.56f, 17.5f, 5.25f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(3.25f)
                curveTo(16.5f, 2.56f, 15.94f, 2.0f, 15.25f, 2.0f)
                reflectiveCurveTo(14.0f, 2.56f, 14.0f, 3.25f)
                verticalLineToRelative(7.92f)
                lineToRelative(6.0f, 6.0f)
                verticalLineTo(12.75f)
                close()
                moveTo(9.5f, 4.25f)
                curveTo(9.5f, 3.56f, 8.94f, 3.0f, 8.25f, 3.0f)
                curveToRelative(-0.67f, 0.0f, -1.2f, 0.53f, -1.24f, 1.18f)
                lineTo(9.5f, 6.67f)
                verticalLineTo(4.25f)
                close()
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(5.63f, 5.63f)
                lineTo(7.0f, 9.83f)
                verticalLineToRelative(4.3f)
                curveToRelative(-1.11f, -0.64f, -2.58f, -1.47f, -2.6f, -1.48f)
                curveToRelative(-0.17f, -0.09f, -0.34f, -0.14f, -0.54f, -0.14f)
                curveToRelative(-0.26f, 0.0f, -0.5f, 0.09f, -0.7f, 0.26f)
                curveTo(3.12f, 12.78f, 2.0f, 13.88f, 2.0f, 13.88f)
                lineToRelative(6.8f, 7.18f)
                curveToRelative(0.57f, 0.6f, 1.35f, 0.94f, 2.18f, 0.94f)
                horizontalLineTo(17.0f)
                curveToRelative(0.62f, 0.0f, 1.18f, -0.19f, 1.65f, -0.52f)
                lineToRelative(-0.02f, -0.02f)
                lineToRelative(1.15f, 1.15f)
                lineTo(21.19f, 21.19f)
                close()
            }
        }
        return _doNotTouch!!
    }

private var _doNotTouch: ImageVector? = null
