/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.HotelClass: ImageVector
    get() {
        if (_hotelClass != null) {
            return _hotelClass!!
        }
        _hotelClass = materialIcon(name = "Filled.HotelClass") {
            materialPath {
                moveTo(8.58f, 10.0f)
                horizontalLineTo(1.0f)
                lineToRelative(6.17f, 4.41f)
                lineTo(4.83f, 22.0f)
                lineTo(11.0f, 17.31f)
                lineTo(17.18f, 22.0f)
                lineToRelative(-2.35f, -7.59f)
                lineTo(21.0f, 10.0f)
                horizontalLineToRelative(-7.58f)
                lineTo(11.0f, 2.0f)
                lineTo(8.58f, 10.0f)
                close()
                moveTo(21.36f, 22.0f)
                lineToRelative(-1.86f, -6.01f)
                lineTo(23.68f, 13.0f)
                horizontalLineToRelative(-3.44f)
                lineToRelative(-3.08f, 2.2f)
                lineToRelative(1.46f, 4.72f)
                lineTo(21.36f, 22.0f)
                close()
                moveTo(17.0f, 8.0f)
                lineToRelative(-1.82f, -6.0f)
                lineToRelative(-1.04f, 3.45f)
                lineTo(14.91f, 8.0f)
                horizontalLineTo(17.0f)
                close()
            }
        }
        return _hotelClass!!
    }

private var _hotelClass: ImageVector? = null
