/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MotionPhotosPaused: ImageVector
    get() {
        if (_motionPhotosPaused != null) {
            return _motionPhotosPaused!!
        }
        _motionPhotosPaused = materialIcon(name = "Filled.MotionPhotosPaused") {
            materialPath {
                moveTo(22.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, -4.48f, 10.0f, -10.0f, 10.0f)
                reflectiveCurveTo(2.0f, 17.52f, 2.0f, 12.0f)
                curveToRelative(0.0f, -1.19f, 0.22f, -2.32f, 0.6f, -3.38f)
                lineTo(4.48f, 9.3f)
                curveTo(4.17f, 10.14f, 4.0f, 11.05f, 4.0f, 12.0f)
                curveToRelative(0.0f, 4.41f, 3.59f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.59f, 8.0f, -8.0f)
                reflectiveCurveToRelative(-3.59f, -8.0f, -8.0f, -8.0f)
                curveToRelative(-0.95f, 0.0f, -1.85f, 0.17f, -2.69f, 0.48f)
                lineTo(8.63f, 2.59f)
                curveTo(9.69f, 2.22f, 10.82f, 2.0f, 12.0f, 2.0f)
                curveTo(17.52f, 2.0f, 22.0f, 6.48f, 22.0f, 12.0f)
                close()
                moveTo(5.5f, 4.0f)
                curveTo(4.67f, 4.0f, 4.0f, 4.67f, 4.0f, 5.5f)
                reflectiveCurveTo(4.67f, 7.0f, 5.5f, 7.0f)
                reflectiveCurveTo(7.0f, 6.33f, 7.0f, 5.5f)
                reflectiveCurveTo(6.33f, 4.0f, 5.5f, 4.0f)
                close()
                moveTo(11.0f, 16.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(8.0f)
                horizontalLineTo(11.0f)
                close()
                moveTo(15.0f, 16.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(8.0f)
                horizontalLineTo(15.0f)
                close()
            }
        }
        return _motionPhotosPaused!!
    }

private var _motionPhotosPaused: ImageVector? = null
