/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.NightlightRound: ImageVector
    get() {
        if (_nightlightRound != null) {
            return _nightlightRound!!
        }
        _nightlightRound = materialIcon(name = "Filled.NightlightRound") {
            materialPath {
                moveTo(12.01f, 12.0f)
                curveToRelative(0.0f, -3.57f, 2.2f, -6.62f, 5.31f, -7.87f)
                curveToRelative(0.89f, -0.36f, 0.75f, -1.69f, -0.19f, -1.9f)
                curveToRelative(-1.1f, -0.24f, -2.27f, -0.3f, -3.48f, -0.14f)
                curveToRelative(-4.51f, 0.6f, -8.12f, 4.31f, -8.59f, 8.83f)
                curveTo(4.44f, 16.93f, 9.13f, 22.0f, 15.01f, 22.0f)
                curveToRelative(0.73f, 0.0f, 1.43f, -0.08f, 2.12f, -0.23f)
                curveToRelative(0.95f, -0.21f, 1.1f, -1.53f, 0.2f, -1.9f)
                curveToRelative(-3.22f, -1.29f, -5.33f, -4.41f, -5.32f, -7.87f)
                close()
            }
        }
        return _nightlightRound!!
    }

private var _nightlightRound: ImageVector? = null
