/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Snowmobile: ImageVector
    get() {
        if (_snowmobile != null) {
            return _snowmobile!!
        }
        _snowmobile = materialIcon(name = "Filled.Snowmobile") {
            materialPath {
                moveTo(22.0f, 17.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-0.17f)
                lineToRelative(-2.2f, -2.2f)
                curveTo(20.58f, 15.37f, 22.0f, 14.4f, 22.0f, 13.0f)
                curveToRelative(0.0f, -1.0f, -8.0f, -8.0f, -8.0f, -8.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.25f)
                lineToRelative(1.45f, 1.3f)
                lineTo(11.0f, 11.0f)
                lineToRelative(-9.5f, -1.0f)
                lineTo(0.0f, 13.0f)
                lineToRelative(4.54f, 1.36f)
                lineToRelative(-3.49f, 1.88f)
                curveTo(-0.77f, 17.22f, -0.07f, 20.0f, 2.0f, 20.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                horizontalLineToRelative(4.0f)
                lineToRelative(2.0f, 2.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                horizontalLineTo(22.0f)
                close()
                moveTo(8.0f, 18.0f)
                horizontalLineTo(2.0f)
                lineToRelative(5.25f, -2.83f)
                lineTo(10.0f, 16.0f)
                curveTo(10.0f, 17.1f, 9.11f, 18.0f, 8.0f, 18.0f)
                close()
            }
        }
        return _snowmobile!!
    }

private var _snowmobile: ImageVector? = null
