/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.UpdateDisabled: ImageVector
    get() {
        if (_updateDisabled != null) {
            return _updateDisabled!!
        }
        _updateDisabled = materialIcon(name = "Filled.UpdateDisabled") {
            materialPath {
                moveTo(8.67f, 5.84f)
                lineTo(7.22f, 4.39f)
                curveTo(8.6f, 3.51f, 10.24f, 3.0f, 12.0f, 3.0f)
                curveToRelative(2.74f, 0.0f, 5.19f, 1.23f, 6.84f, 3.16f)
                lineTo(21.0f, 4.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(-6.0f)
                lineToRelative(2.41f, -2.41f)
                curveTo(16.12f, 6.02f, 14.18f, 5.0f, 12.0f, 5.0f)
                curveTo(10.8f, 5.0f, 9.66f, 5.31f, 8.67f, 5.84f)
                close()
                moveTo(13.0f, 7.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.17f)
                lineToRelative(2.0f, 2.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(19.78f, 22.61f)
                lineToRelative(-3.0f, -3.0f)
                curveTo(15.39f, 20.48f, 13.76f, 21.0f, 12.0f, 21.0f)
                curveToRelative(-4.97f, 0.0f, -9.0f, -4.03f, -9.0f, -9.0f)
                curveToRelative(0.0f, -1.76f, 0.51f, -3.4f, 1.39f, -4.78f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(18.38f, 18.38f)
                lineTo(19.78f, 22.61f)
                close()
                moveTo(15.32f, 18.15f)
                lineTo(5.84f, 8.67f)
                curveTo(5.31f, 9.66f, 5.0f, 10.8f, 5.0f, 12.0f)
                curveToRelative(0.0f, 3.86f, 3.14f, 7.0f, 7.0f, 7.0f)
                curveTo(13.2f, 19.0f, 14.34f, 18.69f, 15.32f, 18.15f)
                close()
                moveTo(20.94f, 13.0f)
                horizontalLineToRelative(-2.02f)
                curveToRelative(-0.12f, 0.83f, -0.39f, 1.61f, -0.77f, 2.32f)
                lineToRelative(1.47f, 1.47f)
                curveTo(20.32f, 15.67f, 20.79f, 14.38f, 20.94f, 13.0f)
                close()
            }
        }
        return _updateDisabled!!
    }

private var _updateDisabled: ImageVector? = null
