/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Adb: ImageVector
    get() {
        if (_adb != null) {
            return _adb!!
        }
        _adb = materialIcon(name = "Outlined.Adb") {
            materialPath {
                moveTo(5.0f, 16.0f)
                curveToRelative(0.0f, 3.87f, 3.13f, 7.0f, 7.0f, 7.0f)
                reflectiveCurveToRelative(7.0f, -3.13f, 7.0f, -7.0f)
                verticalLineToRelative(-4.0f)
                lineTo(5.0f, 12.0f)
                verticalLineToRelative(4.0f)
                close()
                moveTo(16.12f, 4.37f)
                lineToRelative(2.1f, -2.1f)
                lineToRelative(-0.82f, -0.83f)
                lineToRelative(-2.3f, 2.31f)
                curveTo(14.16f, 3.28f, 13.12f, 3.0f, 12.0f, 3.0f)
                reflectiveCurveToRelative(-2.16f, 0.28f, -3.09f, 0.75f)
                lineTo(6.6f, 1.44f)
                lineToRelative(-0.82f, 0.83f)
                lineToRelative(2.1f, 2.1f)
                curveTo(6.14f, 5.64f, 5.0f, 7.68f, 5.0f, 10.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -2.32f, -1.14f, -4.36f, -2.88f, -5.63f)
                close()
                moveTo(9.0f, 9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                close()
                moveTo(15.0f, 9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                close()
            }
        }
        return _adb!!
    }

private var _adb: ImageVector? = null
