/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.HourglassDisabled: ImageVector
    get() {
        if (_hourglassDisabled != null) {
            return _hourglassDisabled!!
        }
        _hourglassDisabled = materialIcon(name = "Outlined.HourglassDisabled") {
            materialPath {
                moveTo(8.0f, 4.0f)
                lineToRelative(8.0f, 0.0f)
                lineToRelative(0.0f, 3.5f)
                lineToRelative(-2.84f, 2.84f)
                lineToRelative(1.25f, 1.25f)
                lineToRelative(3.59f, -3.58f)
                lineToRelative(-0.01f, -0.01f)
                lineToRelative(0.01f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                lineToRelative(-12.0f, 0.0f)
                lineToRelative(0.0f, 1.17f)
                lineToRelative(2.0f, 2.0f)
                close()
            }
            materialPath {
                moveTo(2.1f, 2.1f)
                lineTo(0.69f, 3.51f)
                lineToRelative(8.9f, 8.9f)
                lineTo(6.0f, 16.0f)
                lineToRelative(0.01f, 0.01f)
                horizontalLineTo(6.0f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-1.17f)
                lineToRelative(2.49f, 2.49f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.1f, 2.1f)
                close()
                moveTo(16.0f, 20.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-3.5f)
                lineToRelative(2.84f, -2.84f)
                lineTo(16.0f, 18.83f)
                verticalLineTo(20.0f)
                close()
            }
        }
        return _hourglassDisabled!!
    }

private var _hourglassDisabled: ImageVector? = null
