/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.PanoramaHorizontalSelect: ImageVector
    get() {
        if (_panoramaHorizontalSelect != null) {
            return _panoramaHorizontalSelect!!
        }
        _panoramaHorizontalSelect = materialIcon(name = "Outlined.PanoramaHorizontalSelect") {
            materialPath {
                moveTo(12.0f, 5.5f)
                curveToRelative(-3.89f, 0.0f, -6.95f, -0.84f, -8.69f, -1.43f)
                curveTo(2.67f, 3.85f, 2.0f, 4.33f, 2.0f, 5.02f)
                lineTo(2.0f, 19.0f)
                curveToRelative(0.0f, 0.68f, 0.66f, 1.17f, 1.31f, 0.95f)
                curveTo(5.36f, 19.26f, 8.1f, 18.5f, 12.0f, 18.5f)
                curveToRelative(3.87f, 0.0f, 6.66f, 0.76f, 8.69f, 1.45f)
                curveTo(21.34f, 20.16f, 22.0f, 19.68f, 22.0f, 19.0f)
                lineToRelative(0.0f, -14.0f)
                curveToRelative(0.0f, -0.68f, -0.66f, -1.17f, -1.31f, -0.95f)
                curveTo(18.66f, 4.73f, 15.86f, 5.5f, 12.0f, 5.5f)
                close()
            }
        }
        return _panoramaHorizontalSelect!!
    }

private var _panoramaHorizontalSelect: ImageVector? = null
