/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.TransferWithinAStation: ImageVector
    get() {
        if (_transferWithinAStation != null) {
            return _transferWithinAStation!!
        }
        _transferWithinAStation = materialIcon(name = "Outlined.TransferWithinAStation") {
            materialPath {
                moveTo(16.49f, 15.5f)
                verticalLineToRelative(-1.75f)
                lineTo(14.0f, 16.25f)
                lineToRelative(2.49f, 2.5f)
                lineTo(16.49f, 17.0f)
                lineTo(22.0f, 17.0f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(-5.51f)
                close()
                moveTo(19.51f, 19.75f)
                lineTo(14.0f, 19.75f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(5.51f)
                lineTo(19.51f, 23.0f)
                lineTo(22.0f, 20.5f)
                lineTo(19.51f, 18.0f)
                verticalLineToRelative(1.75f)
                close()
                moveTo(9.5f, 5.5f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                close()
                moveTo(5.75f, 8.9f)
                lineTo(3.0f, 23.0f)
                horizontalLineToRelative(2.1f)
                lineToRelative(1.75f, -8.0f)
                lineTo(9.0f, 17.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-7.55f)
                lineTo(8.95f, 13.4f)
                lineToRelative(0.6f, -3.0f)
                curveTo(10.85f, 12.0f, 12.8f, 13.0f, 15.0f, 13.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-1.85f, 0.0f, -3.45f, -1.0f, -4.35f, -2.45f)
                lineToRelative(-0.95f, -1.6f)
                curveTo(9.35f, 6.35f, 8.7f, 6.0f, 8.0f, 6.0f)
                curveToRelative(-0.25f, 0.0f, -0.5f, 0.05f, -0.75f, 0.15f)
                lineTo(2.0f, 8.3f)
                lineTo(2.0f, 13.0f)
                horizontalLineToRelative(2.0f)
                lineTo(4.0f, 9.65f)
                lineToRelative(1.75f, -0.75f)
            }
        }
        return _transferWithinAStation!!
    }

private var _transferWithinAStation: ImageVector? = null
