/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AutoMode: ImageVector
    get() {
        if (_autoMode != null) {
            return _autoMode!!
        }
        _autoMode = materialIcon(name = "Rounded.AutoMode") {
            materialPath {
                moveTo(18.06f, 2.83f)
                curveToRelative(-1.15f, -0.77f, -2.46f, -1.32f, -3.86f, -1.61f)
                curveTo(13.58f, 1.1f, 13.0f, 1.57f, 13.0f, 2.21f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.46f, 0.31f, 0.88f, 0.76f, 0.97f)
                curveToRelative(1.17f, 0.23f, 2.26f, 0.7f, 3.21f, 1.34f)
                curveToRelative(0.39f, 0.26f, 0.9f, 0.19f, 1.23f, -0.14f)
                lineToRelative(0.0f, 0.0f)
                curveTo(18.66f, 3.93f, 18.59f, 3.18f, 18.06f, 2.83f)
                close()
            }
            materialPath {
                moveTo(11.0f, 2.21f)
                lineTo(11.0f, 2.21f)
                curveToRelative(0.0f, -0.64f, -0.58f, -1.11f, -1.2f, -0.99f)
                curveToRelative(-1.4f, 0.29f, -2.71f, 0.84f, -3.86f, 1.61f)
                curveToRelative(-0.52f, 0.35f, -0.59f, 1.1f, -0.15f, 1.54f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.33f, 0.33f, 0.84f, 0.4f, 1.23f, 0.14f)
                curveToRelative(0.96f, -0.64f, 2.04f, -1.1f, 3.21f, -1.34f)
                curveTo(10.69f, 3.09f, 11.0f, 2.67f, 11.0f, 2.21f)
                close()
            }
            materialPath {
                moveTo(4.38f, 5.79f)
                lineTo(4.38f, 5.79f)
                curveTo(3.93f, 5.34f, 3.18f, 5.42f, 2.84f, 5.94f)
                curveTo(2.07f, 7.09f, 1.51f, 8.39f, 1.23f, 9.8f)
                curveTo(1.1f, 10.42f, 1.58f, 11.0f, 2.21f, 11.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.46f, 0.0f, 0.88f, -0.31f, 0.97f, -0.76f)
                curveToRelative(0.23f, -1.17f, 0.7f, -2.26f, 1.34f, -3.22f)
                curveTo(4.77f, 6.64f, 4.7f, 6.12f, 4.38f, 5.79f)
                close()
            }
            materialPath {
                moveTo(21.79f, 11.0f)
                lineTo(21.79f, 11.0f)
                curveToRelative(0.63f, 0.0f, 1.11f, -0.58f, 0.98f, -1.2f)
                curveToRelative(-0.29f, -1.4f, -0.84f, -2.7f, -1.61f, -3.86f)
                curveToRelative(-0.35f, -0.52f, -1.1f, -0.6f, -1.54f, -0.15f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.33f, 0.33f, -0.4f, 0.84f, -0.14f, 1.23f)
                curveToRelative(0.64f, 0.96f, 1.1f, 2.05f, 1.34f, 3.22f)
                curveTo(20.91f, 10.69f, 21.33f, 11.0f, 21.79f, 11.0f)
                close()
            }
            materialPath {
                moveTo(8.0f, 12.46f)
                lineToRelative(2.44f, 1.11f)
                lineTo(11.54f, 16.0f)
                curveToRelative(0.18f, 0.39f, 0.73f, 0.39f, 0.91f, 0.0f)
                lineToRelative(1.11f, -2.44f)
                lineTo(16.0f, 12.46f)
                curveToRelative(0.39f, -0.18f, 0.39f, -0.73f, 0.0f, -0.91f)
                lineToRelative(-2.44f, -1.11f)
                lineTo(12.46f, 8.0f)
                curveToRelative(-0.18f, -0.39f, -0.73f, -0.39f, -0.91f, 0.0f)
                lineToRelative(-1.11f, 2.44f)
                lineTo(8.0f, 11.54f)
                curveTo(7.61f, 11.72f, 7.61f, 12.28f, 8.0f, 12.46f)
                close()
            }
            materialPath {
                moveTo(12.0f, 21.0f)
                curveToRelative(-3.11f, 0.0f, -5.85f, -1.59f, -7.46f, -4.0f)
                horizontalLineTo(6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.7f)
                curveToRelative(1.99f, 2.84f, 5.27f, 4.7f, 9.0f, 4.7f)
                curveToRelative(4.45f, 0.0f, 8.27f, -2.64f, 10.0f, -6.43f)
                curveToRelative(0.26f, -0.57f, -0.08f, -1.25f, -0.69f, -1.39f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.45f, -0.1f, -0.93f, 0.11f, -1.12f, 0.54f)
                curveTo(18.77f, 18.83f, 15.64f, 21.0f, 12.0f, 21.0f)
                close()
            }
        }
        return _autoMode!!
    }

private var _autoMode: ImageVector? = null
