/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Diversity2: ImageVector
    get() {
        if (_diversity2 != null) {
            return _diversity2!!
        }
        _diversity2 = materialIcon(name = "Rounded.Diversity2") {
            materialPath {
                moveTo(10.77f, 15.23f)
                lineTo(10.77f, 15.23f)
                curveToRelative(0.4f, -0.4f, 0.39f, -1.07f, -0.04f, -1.45f)
                curveTo(8.17f, 11.47f, 6.65f, 9.9f, 7.07f, 8.33f)
                curveTo(7.29f, 7.52f, 8.01f, 7.0f, 8.85f, 7.0f)
                curveToRelative(1.11f, 0.0f, 1.54f, 0.65f, 2.68f, 2.0f)
                horizontalLineToRelative(0.93f)
                curveToRelative(1.12f, -1.31f, 1.53f, -2.0f, 2.68f, -2.0f)
                curveToRelative(0.87f, 0.0f, 1.55f, 0.54f, 1.77f, 1.32f)
                curveToRelative(0.35f, -0.04f, 0.68f, -0.06f, 1.0f, -0.06f)
                curveToRelative(0.36f, 0.0f, 0.7f, 0.03f, 1.03f, 0.08f)
                curveTo(18.7f, 6.43f, 17.13f, 5.0f, 15.15f, 5.0f)
                curveToRelative(-0.12f, 0.0f, -0.23f, 0.03f, -0.35f, 0.04f)
                curveToRelative(0.26f, -0.71f, 0.31f, -1.53f, -0.18f, -2.43f)
                curveTo(14.19f, 1.8f, 13.4f, 1.18f, 12.5f, 1.04f)
                curveTo(10.62f, 0.74f, 9.0f, 2.18f, 9.0f, 4.0f)
                curveToRelative(0.0f, 0.37f, 0.08f, 0.71f, 0.2f, 1.04f)
                curveTo(9.08f, 5.03f, 8.97f, 5.0f, 8.85f, 5.0f)
                curveTo(6.69f, 5.0f, 5.0f, 6.69f, 5.0f, 8.85f)
                curveToRelative(0.0f, 2.23f, 1.73f, 4.01f, 4.4f, 6.41f)
                curveTo(9.79f, 15.62f, 10.4f, 15.6f, 10.77f, 15.23f)
                close()
            }
            materialPath {
                moveTo(23.52f, 17.25f)
                curveToRelative(-0.54f, -0.87f, -1.27f, -1.23f, -2.01f, -1.36f)
                curveToRelative(0.07f, -0.1f, 0.15f, -0.18f, 0.21f, -0.28f)
                curveToRelative(1.08f, -1.87f, 0.46f, -4.18f, -1.41f, -5.26f)
                curveToRelative(-1.93f, -1.11f, -4.34f, -0.5f, -7.75f, 0.6f)
                curveToRelative(-0.51f, 0.16f, -0.79f, 0.7f, -0.66f, 1.21f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.15f, 0.55f, 0.73f, 0.87f, 1.28f, 0.69f)
                curveToRelative(3.28f, -1.06f, 5.4f, -1.6f, 6.55f, -0.45f)
                curveToRelative(0.59f, 0.59f, 0.68f, 1.48f, 0.26f, 2.21f)
                curveToRelative(-0.56f, 0.96f, -1.33f, 1.0f, -3.07f, 1.32f)
                lineToRelative(-0.47f, 0.81f)
                curveToRelative(0.58f, 1.62f, 0.97f, 2.33f, 0.39f, 3.32f)
                curveToRelative(-0.53f, 0.91f, -1.61f, 1.2f, -2.53f, 0.68f)
                curveToRelative(-0.06f, -0.03f, -0.11f, -0.09f, -0.17f, -0.13f)
                curveToRelative(-0.3f, 0.67f, -0.64f, 1.24f, -1.03f, 1.73f)
                curveToRelative(0.0f, 0.01f, 0.0f, 0.01f, 0.0f, 0.01f)
                curveToRelative(1.9f, 1.24f, 4.34f, 0.64f, 5.46f, -1.29f)
                curveToRelative(0.06f, -0.1f, 0.09f, -0.21f, 0.14f, -0.32f)
                curveToRelative(0.22f, 0.27f, 0.48f, 0.51f, 0.8f, 0.69f)
                curveToRelative(1.58f, 0.91f, 3.64f, 0.23f, 4.31f, -1.55f)
                curveTo(24.14f, 19.02f, 24.0f, 18.03f, 23.52f, 17.25f)
                close()
            }
            materialPath {
                moveTo(12.1f, 15.04f)
                curveToRelative(-0.72f, 3.38f, -1.32f, 5.48f, -2.89f, 5.9f)
                curveToRelative(-0.81f, 0.22f, -1.62f, -0.15f, -2.04f, -0.88f)
                curveToRelative(-0.56f, -0.96f, -0.2f, -1.66f, 0.39f, -3.32f)
                lineTo(7.1f, 15.93f)
                curveToRelative(-1.7f, -0.31f, -2.5f, -0.33f, -3.07f, -1.32f)
                curveToRelative(-0.53f, -0.91f, -0.24f, -2.0f, 0.68f, -2.53f)
                curveToRelative(0.09f, -0.05f, 0.19f, -0.08f, 0.29f, -0.11f)
                curveToRelative(-0.27f, -0.42f, -0.5f, -0.87f, -0.67f, -1.37f)
                curveToRelative(-0.24f, -0.11f, -0.36f, -0.16f, -0.6f, -0.26f)
                curveToRelative(-1.88f, 1.07f, -2.51f, 3.4f, -1.43f, 5.27f)
                curveToRelative(0.06f, 0.1f, 0.14f, 0.18f, 0.21f, 0.28f)
                curveToRelative(-0.75f, 0.13f, -1.48f, 0.49f, -2.01f, 1.36f)
                curveToRelative(-0.48f, 0.78f, -0.62f, 1.77f, -0.3f, 2.63f)
                curveToRelative(0.68f, 1.78f, 2.74f, 2.46f, 4.31f, 1.55f)
                curveToRelative(0.32f, -0.18f, 0.58f, -0.42f, 0.8f, -0.69f)
                curveToRelative(0.05f, 0.11f, 0.08f, 0.22f, 0.14f, 0.32f)
                curveToRelative(1.08f, 1.87f, 3.39f, 2.49f, 5.26f, 1.41f)
                curveToRelative(1.93f, -1.11f, 2.61f, -3.51f, 3.36f, -7.01f)
                curveToRelative(0.11f, -0.52f, -0.21f, -1.04f, -0.72f, -1.17f)
                lineToRelative(0.0f, 0.0f)
                curveTo(12.78f, 14.14f, 12.22f, 14.48f, 12.1f, 15.04f)
                close()
            }
        }
        return _diversity2!!
    }

private var _diversity2: ImageVector? = null
