/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FormatClear: ImageVector
    get() {
        if (_formatClear != null) {
            return _formatClear!!
        }
        _formatClear = materialIcon(name = "Rounded.FormatClear") {
            materialPath {
                moveTo(18.5f, 8.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(19.33f, 5.0f, 18.5f, 5.0f)
                lineTo(6.39f, 5.0f)
                lineToRelative(3.0f, 3.0f)
                horizontalLineToRelative(1.83f)
                lineToRelative(-0.55f, 1.28f)
                lineToRelative(2.09f, 2.09f)
                lineTo(14.21f, 8.0f)
                horizontalLineToRelative(4.29f)
                close()
                moveTo(17.44f, 18.88f)
                lineTo(4.12f, 5.56f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(6.26f, 6.26f)
                lineToRelative(-1.65f, 3.84f)
                curveToRelative(-0.39f, 0.92f, 0.28f, 1.93f, 1.27f, 1.93f)
                curveToRelative(0.55f, 0.0f, 1.05f, -0.33f, 1.27f, -0.84f)
                lineToRelative(1.21f, -2.83f)
                lineToRelative(4.95f, 4.95f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.4f, -0.38f, 0.4f, -1.01f, 0.01f, -1.4f)
                close()
            }
        }
        return _formatClear!!
    }

private var _formatClear: ImageVector? = null
