/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HomeWork: ImageVector
    get() {
        if (_homeWork != null) {
            return _homeWork!!
        }
        _homeWork = materialIcon(name = "Rounded.HomeWork") {
            materialPath {
                moveTo(14.16f, 10.4f)
                lineToRelative(-5.0f, -3.57f)
                curveToRelative(-0.7f, -0.5f, -1.63f, -0.5f, -2.32f, 0.0f)
                lineToRelative(-5.0f, 3.57f)
                curveTo(1.31f, 10.78f, 1.0f, 11.38f, 1.0f, 12.03f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-7.97f)
                curveTo(15.0f, 11.38f, 14.69f, 10.78f, 14.16f, 10.4f)
                close()
            }
            materialPath {
                moveTo(21.03f, 3.0f)
                horizontalLineToRelative(-9.06f)
                curveTo(10.88f, 3.0f, 10.0f, 3.88f, 10.0f, 4.97f)
                lineToRelative(0.09f, 0.09f)
                curveToRelative(0.08f, 0.05f, 0.16f, 0.09f, 0.24f, 0.14f)
                lineToRelative(5.0f, 3.57f)
                curveToRelative(0.76f, 0.54f, 1.3f, 1.34f, 1.54f, 2.23f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(3.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(4.03f)
                curveToRelative(1.09f, 0.0f, 1.97f, -0.88f, 1.97f, -1.97f)
                verticalLineTo(4.97f)
                curveTo(23.0f, 3.88f, 22.12f, 3.0f, 21.03f, 3.0f)
                close()
                moveTo(19.0f, 9.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.0f)
                close()
            }
        }
        return _homeWork!!
    }

private var _homeWork: ImageVector? = null
