/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.InsertPageBreak: ImageVector
    get() {
        if (_insertPageBreak != null) {
            return _insertPageBreak!!
        }
        _insertPageBreak = materialIcon(name = "Rounded.InsertPageBreak") {
            materialPath {
                moveTo(4.0f, 20.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 1.99f, 2.0f)
                horizontalLineTo(18.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(4.0f)
                lineTo(4.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(19.41f, 7.41f)
                lineToRelative(-4.83f, -4.83f)
                curveTo(14.21f, 2.21f, 13.7f, 2.0f, 13.17f, 2.0f)
                horizontalLineTo(6.0f)
                curveTo(4.9f, 2.0f, 4.01f, 2.89f, 4.01f, 3.99f)
                lineToRelative(0.0f, 7.01f)
                horizontalLineTo(20.0f)
                verticalLineTo(8.83f)
                curveTo(20.0f, 8.3f, 19.79f, 7.79f, 19.41f, 7.41f)
                close()
                moveTo(13.0f, 8.0f)
                verticalLineTo(3.5f)
                lineTo(18.5f, 9.0f)
                horizontalLineTo(14.0f)
                curveTo(13.45f, 9.0f, 13.0f, 8.55f, 13.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(15.0f, 14.0f)
                lineTo(15.0f, 14.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveTo(14.55f, 15.0f, 15.0f, 14.55f, 15.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 14.0f)
                lineTo(17.0f, 14.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-4.0f)
                curveTo(17.45f, 13.0f, 17.0f, 13.45f, 17.0f, 14.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 13.0f)
                horizontalLineTo(2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveTo(7.0f, 13.45f, 6.55f, 13.0f, 6.0f, 13.0f)
                close()
            }
        }
        return _insertPageBreak!!
    }

private var _insertPageBreak: ImageVector? = null
