/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SignalWifiStatusbarConnectedNoInternet4: ImageVector
    get() {
        if (_signalWifiStatusbarConnectedNoInternet4 != null) {
            return _signalWifiStatusbarConnectedNoInternet4!!
        }
        _signalWifiStatusbarConnectedNoInternet4 = materialIcon(name =
                "Rounded.SignalWifiStatusbarConnectedNoInternet4") {
            materialPath {
                moveTo(22.92f, 8.0f)
                horizontalLineTo(17.0f)
                verticalLineToRelative(7.99f)
                lineToRelative(-4.29f, 4.3f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.42f, 0.0f)
                lineTo(0.73f, 9.71f)
                curveTo(0.32f, 9.3f, 0.35f, 8.63f, 0.79f, 8.24f)
                curveTo(3.78f, 5.6f, 7.7f, 4.0f, 12.0f, 4.0f)
                curveTo(16.16f, 4.0f, 19.97f, 5.51f, 22.92f, 8.0f)
                close()
                moveTo(20.0f, 18.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                reflectiveCurveTo(20.55f, 18.0f, 20.0f, 18.0f)
                close()
                moveTo(20.0f, 10.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveTo(21.0f, 10.45f, 20.55f, 10.0f, 20.0f, 10.0f)
                close()
            }
        }
        return _signalWifiStatusbarConnectedNoInternet4!!
    }

private var _signalWifiStatusbarConnectedNoInternet4: ImageVector? = null
