/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.VideoStable: ImageVector
    get() {
        if (_videoStable != null) {
            return _videoStable!!
        }
        _videoStable = materialIcon(name = "Rounded.VideoStable") {
            materialPath {
                moveTo(19.96f, 4.01f)
                horizontalLineToRelative(-16.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-12.0f)
                curveTo(21.96f, 4.91f, 21.06f, 4.01f, 19.96f, 4.01f)
                close()
                moveTo(20.0f, 6.0f)
                verticalLineToRelative(12.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(20.0f)
                close()
            }
            materialPath {
                moveTo(18.42f, 9.01f)
                lineTo(7.92f, 6.18f)
                curveTo(7.39f, 6.04f, 6.84f, 6.35f, 6.7f, 6.88f)
                lineToRelative(-1.85f, 6.87f)
                curveToRelative(-0.14f, 0.53f, 0.17f, 1.08f, 0.71f, 1.23f)
                lineToRelative(10.5f, 2.83f)
                curveToRelative(0.53f, 0.14f, 1.08f, -0.17f, 1.23f, -0.71f)
                lineToRelative(1.85f, -6.87f)
                curveTo(19.27f, 9.7f, 18.95f, 9.15f, 18.42f, 9.01f)
                close()
            }
        }
        return _videoStable!!
    }

private var _videoStable: ImageVector? = null
