/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Water: ImageVector
    get() {
        if (_water != null) {
            return _water!!
        }
        _water = materialIcon(name = "Rounded.Water") {
            materialPath {
                moveTo(21.98f, 14.0f)
                horizontalLineTo(22.0f)
                horizontalLineTo(21.98f)
                close()
                moveTo(5.35f, 13.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(0.93f, 0.0f, 1.05f, 0.45f, 2.01f, 0.79f)
                curveToRelative(0.63f, 0.22f, 1.3f, -0.24f, 1.3f, -0.91f)
                curveToRelative(0.0f, -0.52f, -0.23f, -0.83f, -0.64f, -0.97f)
                curveToRelative(-0.6f, -0.22f, -1.15f, -0.9f, -2.69f, -0.9f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.54f, 0.0f, -2.13f, 0.71f, -2.68f, 0.91f)
                curveTo(2.24f, 12.05f, 2.0f, 12.35f, 2.0f, 12.89f)
                curveToRelative(0.0f, 0.67f, 0.66f, 1.13f, 1.29f, 0.91f)
                curveTo(4.35f, 13.44f, 4.39f, 13.0f, 5.35f, 13.0f)
                close()
                moveTo(18.67f, 15.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.1f, 1.0f, -3.34f, 1.0f)
                curveToRelative(-1.24f, 0.0f, -1.38f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.53f, 0.0f, -2.15f, 0.71f, -2.69f, 0.91f)
                curveTo(2.24f, 16.05f, 2.0f, 16.36f, 2.0f, 16.89f)
                curveToRelative(0.0f, 0.67f, 0.66f, 1.13f, 1.3f, 0.91f)
                curveTo(4.32f, 17.44f, 4.38f, 17.0f, 5.34f, 17.0f)
                curveToRelative(1.24f, 0.0f, 1.38f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.1f, -1.0f, 3.34f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.94f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(0.94f, 0.0f, 1.06f, 0.46f, 2.03f, 0.8f)
                curveToRelative(0.63f, 0.22f, 1.3f, -0.24f, 1.3f, -0.91f)
                curveToRelative(0.0f, -0.53f, -0.24f, -0.83f, -0.65f, -0.98f)
                curveTo(20.82f, 15.72f, 20.21f, 15.0f, 18.67f, 15.0f)
                close()
                moveTo(5.35f, 9.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(0.93f, 0.0f, 1.05f, 0.45f, 2.01f, 0.79f)
                curveToRelative(0.63f, 0.22f, 1.3f, -0.24f, 1.3f, -0.91f)
                curveToRelative(0.0f, -0.52f, -0.23f, -0.83f, -0.64f, -0.97f)
                curveTo(20.74f, 7.68f, 20.19f, 7.0f, 18.65f, 7.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveTo(10.04f, 7.0f, 9.9f, 8.0f, 8.66f, 8.0f)
                curveTo(7.47f, 8.0f, 7.24f, 7.0f, 5.33f, 7.0f)
                curveTo(3.79f, 7.0f, 3.2f, 7.71f, 2.65f, 7.91f)
                curveTo(2.24f, 8.05f, 2.0f, 8.35f, 2.0f, 8.89f)
                curveToRelative(0.0f, 0.67f, 0.66f, 1.13f, 1.29f, 0.91f)
                curveTo(4.35f, 9.44f, 4.39f, 9.0f, 5.35f, 9.0f)
                close()
            }
        }
        return _water!!
    }

private var _water: ImageVector? = null
