/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Woman: ImageVector
    get() {
        if (_woman != null) {
            return _woman!!
        }
        _woman = materialIcon(name = "Rounded.Woman") {
            materialPath {
                moveTo(12.0f, 4.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(16.45f, 14.63f)
                lineToRelative(-2.52f, -6.32f)
                curveToRelative(-0.32f, -0.79f, -1.08f, -1.3f, -1.94f, -1.31f)
                curveToRelative(-0.85f, 0.0f, -1.62f, 0.51f, -1.94f, 1.31f)
                lineToRelative(-2.52f, 6.32f)
                curveTo(7.28f, 15.29f, 7.77f, 16.0f, 8.47f, 16.0f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(1.53f)
                curveTo(16.23f, 16.0f, 16.72f, 15.29f, 16.45f, 14.63f)
                close()
            }
        }
        return _woman!!
    }

private var _woman: ImageVector? = null
