/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Dining: ImageVector
    get() {
        if (_dining != null) {
            return _dining!!
        }
        _dining = materialIcon(name = "Sharp.Dining") {
            materialPath {
                moveTo(22.0f, 2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(20.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(2.0f)
                close()
                moveTo(11.0f, 10.3f)
                curveToRelative(0.0f, 0.93f, -0.64f, 1.71f, -1.5f, 1.93f)
                verticalLineTo(19.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-6.77f)
                curveToRelative(-0.86f, -0.22f, -1.5f, -1.0f, -1.5f, -1.93f)
                verticalLineTo(6.0f)
                horizontalLineTo(7.0f)
                horizontalLineToRelative(0.5f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(0.75f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(0.5f)
                horizontalLineToRelative(0.5f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(10.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(0.5f)
                horizontalLineTo(11.0f)
                verticalLineTo(10.3f)
                close()
                moveTo(15.58f, 12.59f)
                lineToRelative(-0.08f, 0.03f)
                verticalLineTo(19.0f)
                horizontalLineTo(14.0f)
                verticalLineToRelative(-6.38f)
                lineToRelative(-0.08f, -0.04f)
                curveToRelative(-0.97f, -0.47f, -1.67f, -1.7f, -1.67f, -3.18f)
                curveToRelative(0.0f, -1.88f, 1.13f, -3.4f, 2.5f, -3.4f)
                curveToRelative(1.38f, 0.0f, 2.5f, 1.53f, 2.5f, 3.41f)
                curveTo(17.25f, 10.89f, 16.55f, 12.12f, 15.58f, 12.59f)
                close()
            }
        }
        return _dining!!
    }

private var _dining: ImageVector? = null
