/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Female: ImageVector
    get() {
        if (_female != null) {
            return _female!!
        }
        _female = materialIcon(name = "Sharp.Female") {
            materialPath {
                moveTo(17.5f, 9.5f)
                curveTo(17.5f, 6.46f, 15.04f, 4.0f, 12.0f, 4.0f)
                reflectiveCurveTo(6.5f, 6.46f, 6.5f, 9.5f)
                curveToRelative(0.0f, 2.7f, 1.94f, 4.93f, 4.5f, 5.4f)
                verticalLineTo(17.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.1f)
                curveTo(15.56f, 14.43f, 17.5f, 12.2f, 17.5f, 9.5f)
                close()
                moveTo(8.5f, 9.5f)
                curveTo(8.5f, 7.57f, 10.07f, 6.0f, 12.0f, 6.0f)
                reflectiveCurveToRelative(3.5f, 1.57f, 3.5f, 3.5f)
                reflectiveCurveTo(13.93f, 13.0f, 12.0f, 13.0f)
                reflectiveCurveTo(8.5f, 11.43f, 8.5f, 9.5f)
                close()
            }
        }
        return _female!!
    }

private var _female: ImageVector? = null
