/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.HeadsetOff: ImageVector
    get() {
        if (_headsetOff != null) {
            return _headsetOff!!
        }
        _headsetOff = materialIcon(name = "Sharp.HeadsetOff") {
            materialPath {
                moveTo(12.0f, 4.0f)
                curveToRelative(3.87f, 0.0f, 7.0f, 3.13f, 7.0f, 7.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(0.17f)
                lineToRelative(6.0f, 6.0f)
                verticalLineTo(11.0f)
                curveToRelative(0.0f, -4.97f, -4.03f, -9.0f, -9.0f, -9.0f)
                curveTo(9.98f, 2.0f, 8.12f, 2.67f, 6.62f, 3.8f)
                lineToRelative(1.43f, 1.43f)
                curveTo(9.17f, 4.45f, 10.53f, 4.0f, 12.0f, 4.0f)
                close()
            }
            materialPath {
                moveTo(2.1f, 2.1f)
                lineTo(0.69f, 3.51f)
                lineToRelative(3.33f, 3.33f)
                curveTo(3.37f, 8.09f, 3.0f, 9.5f, 3.0f, 11.0f)
                verticalLineToRelative(9.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.94f, 0.19f, -1.83f, 0.52f, -2.65f)
                lineTo(15.0f, 17.83f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(2.17f)
                lineToRelative(1.0f, 1.0f)
                horizontalLineTo(12.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(8.17f)
                lineToRelative(0.31f, 0.31f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.1f, 2.1f)
                close()
            }
        }
        return _headsetOff!!
    }

private var _headsetOff: ImageVector? = null
