/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PhoneLocked: ImageVector
    get() {
        if (_phoneLocked != null) {
            return _phoneLocked!!
        }
        _phoneLocked = materialIcon(name = "Sharp.PhoneLocked") {
            materialPath {
                moveTo(20.0f, 5.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(6.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(20.0f)
                close()
                moveTo(19.0f, 5.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(5.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 15.0f)
                lineToRelative(-5.0f, -1.0f)
                lineToRelative(-2.9f, 2.9f)
                curveToRelative(-2.5f, -1.43f, -4.57f, -3.5f, -6.0f, -6.0f)
                lineTo(10.0f, 8.0f)
                lineTo(9.0f, 3.0f)
                lineTo(3.0f, 3.0f)
                curveToRelative(0.0f, 3.28f, 0.89f, 6.35f, 2.43f, 9.0f)
                curveToRelative(1.58f, 2.73f, 3.85f, 4.99f, 6.57f, 6.57f)
                curveToRelative(2.65f, 1.53f, 5.72f, 2.43f, 9.0f, 2.43f)
                lineTo(21.0f, 15.0f)
                close()
            }
        }
        return _phoneLocked!!
    }

private var _phoneLocked: ImageVector? = null
