/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PhonelinkSetup: ImageVector
    get() {
        if (_phonelinkSetup != null) {
            return _phonelinkSetup!!
        }
        _phonelinkSetup = materialIcon(name = "Sharp.PhonelinkSetup") {
            materialPath {
                moveTo(7.0f, 1.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                lineTo(9.0f, 4.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(16.0f)
                lineTo(9.0f, 20.0f)
                verticalLineToRelative(-2.0f)
                lineTo(7.0f, 18.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(14.0f)
                lineTo(21.0f, 1.0f)
                close()
                moveTo(9.5f, 15.5f)
                curveToRelative(0.29f, -0.12f, 0.55f, -0.29f, 0.8f, -0.48f)
                lineToRelative(-0.02f, 0.03f)
                lineToRelative(1.41f, 0.55f)
                lineToRelative(1.27f, -2.2f)
                lineToRelative(-1.18f, -0.95f)
                lineToRelative(-0.02f, 0.03f)
                curveToRelative(0.02f, -0.16f, 0.05f, -0.32f, 0.05f, -0.48f)
                reflectiveCurveToRelative(-0.03f, -0.32f, -0.05f, -0.48f)
                lineToRelative(0.02f, 0.03f)
                lineToRelative(1.18f, -0.95f)
                lineToRelative(-1.26f, -2.2f)
                lineToRelative(-1.41f, 0.55f)
                lineToRelative(0.02f, 0.03f)
                curveToRelative(-0.26f, -0.19f, -0.52f, -0.36f, -0.81f, -0.48f)
                lineTo(9.27f, 7.0f)
                lineTo(6.73f, 7.0f)
                lineTo(6.5f, 8.5f)
                curveToRelative(-0.29f, 0.12f, -0.55f, 0.29f, -0.8f, 0.48f)
                lineToRelative(0.02f, -0.03f)
                lineTo(4.3f, 8.4f)
                lineToRelative(-1.27f, 2.2f)
                lineToRelative(1.18f, 0.95f)
                lineToRelative(0.02f, -0.03f)
                curveToRelative(-0.01f, 0.16f, -0.04f, 0.32f, -0.04f, 0.48f)
                reflectiveCurveToRelative(0.03f, 0.32f, 0.05f, 0.48f)
                lineToRelative(-0.02f, -0.03f)
                lineToRelative(-1.18f, 0.95f)
                lineToRelative(1.27f, 2.2f)
                lineToRelative(1.41f, -0.55f)
                lineToRelative(-0.02f, -0.03f)
                curveToRelative(0.25f, 0.19f, 0.51f, 0.36f, 0.8f, 0.48f)
                lineToRelative(0.23f, 1.5f)
                horizontalLineToRelative(2.54f)
                lineToRelative(0.23f, -1.5f)
                close()
                moveTo(6.0f, 12.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                close()
            }
        }
        return _phonelinkSetup!!
    }

private var _phonelinkSetup: ImageVector? = null
