/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SignalCellularNoSim: ImageVector
    get() {
        if (_signalCellularNoSim != null) {
            return _signalCellularNoSim!!
        }
        _signalCellularNoSim = materialIcon(name = "Sharp.SignalCellularNoSim") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineToRelative(-9.0f)
                lineTo(7.95f, 5.06f)
                lineTo(19.0f, 16.11f)
                close()
                moveTo(3.79f, 3.74f)
                lineTo(2.38f, 5.15f)
                lineTo(5.0f, 7.77f)
                lineTo(5.0f, 21.0f)
                horizontalLineToRelative(13.23f)
                lineToRelative(1.62f, 1.62f)
                lineToRelative(1.41f, -1.41f)
                close()
            }
        }
        return _signalCellularNoSim!!
    }

private var _signalCellularNoSim: ImageVector? = null
