/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Toys: ImageVector
    get() {
        if (_toys != null) {
            return _toys!!
        }
        _toys = materialIcon(name = "Sharp.Toys") {
            materialPath {
                moveTo(18.72f, 10.0f)
                lineToRelative(-2.0f, -6.0f)
                horizontalLineTo(7.28f)
                lineTo(5.81f, 8.4f)
                lineTo(4.41f, 7.0f)
                lineToRelative(1.0f, -1.0f)
                lineTo(4.0f, 4.59f)
                lineTo(0.59f, 8.0f)
                lineTo(2.0f, 9.41f)
                lineToRelative(1.0f, -1.0f)
                lineTo(4.59f, 10.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(8.0f)
                horizontalLineToRelative(2.18f)
                curveTo(4.59f, 19.16f, 5.7f, 20.0f, 7.0f, 20.0f)
                curveToRelative(1.3f, 0.0f, 2.4f, -0.84f, 2.82f, -2.0f)
                horizontalLineToRelative(4.37f)
                curveToRelative(0.41f, 1.16f, 1.51f, 2.0f, 2.82f, 2.0f)
                curveToRelative(1.3f, 0.0f, 2.41f, -0.84f, 2.82f, -2.0f)
                horizontalLineTo(22.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineTo(18.72f)
                close()
                moveTo(7.0f, 18.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(7.55f, 18.0f, 7.0f, 18.0f)
                close()
                moveTo(11.0f, 10.0f)
                horizontalLineTo(7.41f)
                lineTo(7.39f, 9.98f)
                lineTo(8.72f, 6.0f)
                curveToRelative(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(10.0f)
                close()
                moveTo(13.0f, 10.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(2.28f)
                lineToRelative(1.33f, 4.0f)
                horizontalLineTo(13.0f)
                close()
                moveTo(17.0f, 18.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(17.55f, 18.0f, 17.0f, 18.0f)
                close()
            }
        }
        return _toys!!
    }

private var _toys: ImageVector? = null
