/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FormatColorReset: ImageVector
    get() {
        if (_formatColorReset != null) {
            return _formatColorReset!!
        }
        _formatColorReset = materialIcon(name = "TwoTone.FormatColorReset") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.93f, 7.83f)
                lineToRelative(4.77f, 4.77f)
                curveToRelative(-0.62f, -1.81f, -2.17f, -4.24f, -3.71f, -6.24f)
                curveToRelative(-0.35f, 0.47f, -0.71f, 0.96f, -1.06f, 1.47f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(0.96f, 0.0f, 1.83f, -0.36f, 2.53f, -0.92f)
                lineToRelative(-5.72f, -5.72f)
                curveTo(8.32f, 12.38f, 8.0f, 13.31f, 8.0f, 14.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 6.36f)
                curveToRelative(1.53f, 2.0f, 3.08f, 4.43f, 3.71f, 6.24f)
                lineToRelative(2.23f, 2.23f)
                curveToRelative(0.03f, -0.27f, 0.06f, -0.55f, 0.06f, -0.83f)
                curveToRelative(0.0f, -3.98f, -6.0f, -10.8f, -6.0f, -10.8f)
                reflectiveCurveToRelative(-1.18f, 1.35f, -2.5f, 3.19f)
                lineToRelative(1.44f, 1.44f)
                curveToRelative(0.34f, -0.51f, 0.7f, -1.0f, 1.06f, -1.47f)
                close()
                moveTo(5.41f, 5.14f)
                lineTo(4.0f, 6.55f)
                lineToRelative(3.32f, 3.32f)
                curveTo(6.55f, 11.33f, 6.0f, 12.79f, 6.0f, 14.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                curveToRelative(1.52f, 0.0f, 2.9f, -0.57f, 3.95f, -1.5f)
                lineToRelative(2.63f, 2.63f)
                lineTo(20.0f, 19.72f)
                lineTo(5.41f, 5.14f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                curveToRelative(0.0f, -0.69f, 0.32f, -1.62f, 0.81f, -2.64f)
                lineToRelative(5.72f, 5.72f)
                curveToRelative(-0.7f, 0.56f, -1.57f, 0.92f, -2.53f, 0.92f)
                close()
            }
        }
        return _formatColorReset!!
    }

private var _formatColorReset: ImageVector? = null
