/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.GppGood: ImageVector
    get() {
        if (_gppGood != null) {
            return _gppGood!!
        }
        _gppGood = materialIcon(name = "TwoTone.GppGood") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.0f, 6.31f)
                verticalLineToRelative(4.78f)
                curveToRelative(0.0f, 4.0f, 2.55f, 7.7f, 6.0f, 8.83f)
                curveToRelative(3.45f, -1.13f, 6.0f, -4.82f, 6.0f, -8.83f)
                verticalLineTo(6.31f)
                lineToRelative(-6.0f, -2.12f)
                lineTo(6.0f, 6.31f)
                close()
                moveTo(16.6f, 9.88f)
                lineToRelative(-5.66f, 5.66f)
                lineTo(7.4f, 12.0f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(4.24f, -4.24f)
                lineTo(16.6f, 9.88f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                lineTo(4.0f, 5.0f)
                verticalLineToRelative(6.09f)
                curveToRelative(0.0f, 5.05f, 3.41f, 9.76f, 8.0f, 10.91f)
                curveToRelative(4.59f, -1.15f, 8.0f, -5.86f, 8.0f, -10.91f)
                verticalLineTo(5.0f)
                lineTo(12.0f, 2.0f)
                close()
                moveTo(18.0f, 11.09f)
                curveToRelative(0.0f, 4.0f, -2.55f, 7.7f, -6.0f, 8.83f)
                curveToRelative(-3.45f, -1.13f, -6.0f, -4.82f, -6.0f, -8.83f)
                verticalLineTo(6.31f)
                lineToRelative(6.0f, -2.12f)
                lineToRelative(6.0f, 2.12f)
                verticalLineTo(11.09f)
                close()
                moveTo(8.82f, 10.59f)
                lineTo(7.4f, 12.0f)
                lineToRelative(3.54f, 3.54f)
                lineToRelative(5.66f, -5.66f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-4.24f, 4.24f)
                lineTo(8.82f, 10.59f)
                close()
            }
        }
        return _gppGood!!
    }

private var _gppGood: ImageVector? = null
