/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.MarkEmailUnread: ImageVector
    get() {
        if (_markEmailUnread != null) {
            return _markEmailUnread!!
        }
        _markEmailUnread = materialIcon(name = "TwoTone.MarkEmailUnread") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 6.0f)
                horizontalLineToRelative(10.1f)
                curveToRelative(0.22f, 1.07f, 0.79f, 2.0f, 1.57f, 2.71f)
                lineTo(12.0f, 11.0f)
                lineTo(4.0f, 6.0f)
                close()
                moveTo(4.0f, 8.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(9.9f)
                curveToRelative(-0.32f, 0.07f, -0.66f, 0.1f, -1.0f, 0.1f)
                curveToRelative(-0.6f, 0.0f, -1.16f, -0.12f, -1.7f, -0.32f)
                lineTo(12.0f, 13.0f)
                lineTo(4.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 9.9f)
                curveToRelative(0.74f, -0.15f, 1.42f, -0.48f, 2.0f, -0.92f)
                verticalLineTo(18.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(10.1f)
                curveTo(14.04f, 4.32f, 14.0f, 4.66f, 14.0f, 5.0f)
                reflectiveCurveToRelative(0.04f, 0.68f, 0.1f, 1.0f)
                horizontalLineTo(4.0f)
                lineToRelative(8.0f, 5.0f)
                lineToRelative(3.67f, -2.29f)
                curveToRelative(0.47f, 0.43f, 1.02f, 0.76f, 1.63f, 0.98f)
                lineTo(12.0f, 13.0f)
                lineTo(4.0f, 8.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(16.0f)
                verticalLineTo(9.9f)
                close()
                moveTo(16.0f, 5.0f)
                curveToRelative(0.0f, 1.66f, 1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveToRelative(3.0f, -1.34f, 3.0f, -3.0f)
                reflectiveCurveToRelative(-1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(16.0f, 3.34f, 16.0f, 5.0f)
                close()
            }
        }
        return _markEmailUnread!!
    }

private var _markEmailUnread: ImageVector? = null
