/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PlayLesson: ImageVector
    get() {
        if (_playLesson != null) {
            return _playLesson!!
        }
        _playLesson = materialIcon(name = "TwoTone.PlayLesson") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 4.0f)
                verticalLineToRelative(7.0f)
                lineTo(9.5f, 9.5f)
                lineTo(7.0f, 11.0f)
                verticalLineTo(4.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(6.29f)
                curveTo(11.1f, 19.37f, 11.0f, 18.7f, 11.0f, 18.0f)
                curveToRelative(0.0f, -3.53f, 2.61f, -6.43f, 6.0f, -6.92f)
                verticalLineTo(4.0f)
                horizontalLineTo(12.0f)
                close()
            }
            materialPath {
                moveTo(5.0f, 20.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(7.0f)
                lineToRelative(2.5f, -1.5f)
                lineTo(12.0f, 11.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(7.08f)
                curveToRelative(0.33f, -0.05f, 0.66f, -0.08f, 1.0f, -0.08f)
                reflectiveCurveToRelative(0.67f, 0.03f, 1.0f, 0.08f)
                verticalLineTo(4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 2.0f, 3.0f, 2.9f, 3.0f, 4.0f)
                verticalLineToRelative(16.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(7.26f)
                curveToRelative(-0.42f, -0.6f, -0.75f, -1.28f, -0.97f, -2.0f)
                horizontalLineTo(5.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(20.76f, 13.0f, 18.0f, 13.0f)
                close()
                moveTo(16.75f, 20.5f)
                verticalLineToRelative(-5.0f)
                lineToRelative(4.0f, 2.5f)
                lineTo(16.75f, 20.5f)
                close()
            }
        }
        return _playLesson!!
    }

private var _playLesson: ImageVector? = null
