/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SportsRugby: ImageVector
    get() {
        if (_sportsRugby != null) {
            return _sportsRugby!!
        }
        _sportsRugby = materialIcon(name = "TwoTone.SportsRugby") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.29f, 5.71f)
                curveToRelative(-1.93f, 0.64f, -5.02f, 2.19f, -7.7f, 4.88f)
                curveToRelative(-2.71f, 2.71f, -4.24f, 5.81f, -4.87f, 7.7f)
                curveToRelative(1.93f, -0.64f, 5.03f, -2.2f, 7.7f, -4.87f)
                curveTo(16.13f, 10.7f, 17.66f, 7.6f, 18.29f, 5.71f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.17f, 9.17f)
                curveToRelative(2.15f, -2.15f, 4.56f, -3.67f, 6.61f, -4.61f)
                curveTo(14.1f, 4.64f, 10.4f, 5.12f, 7.76f, 7.76f)
                curveToRelative(-2.32f, 2.32f, -3.1f, 5.58f, -3.2f, 8.04f)
                curveTo(5.5f, 13.75f, 7.01f, 11.33f, 9.17f, 9.17f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.83f, 14.83f)
                curveToRelative(-2.15f, 2.15f, -4.56f, 3.67f, -6.61f, 4.61f)
                curveToRelative(1.68f, -0.08f, 5.39f, -0.55f, 8.03f, -3.19f)
                curveToRelative(2.32f, -2.32f, 3.1f, -5.58f, 3.2f, -8.04f)
                curveTo(18.5f, 10.25f, 16.99f, 12.67f, 14.83f, 14.83f)
                close()
            }
            materialPath {
                moveTo(20.49f, 3.51f)
                curveToRelative(-0.56f, -0.56f, -2.15f, -0.97f, -4.16f, -0.97f)
                curveToRelative(-3.08f, 0.0f, -7.15f, 0.96f, -9.98f, 3.79f)
                curveTo(1.66f, 11.03f, 2.1f, 19.07f, 3.51f, 20.49f)
                curveToRelative(0.56f, 0.56f, 2.15f, 0.97f, 4.16f, 0.97f)
                curveToRelative(3.08f, 0.0f, 7.15f, -0.96f, 9.98f, -3.79f)
                curveTo(22.34f, 12.97f, 21.9f, 4.93f, 20.49f, 3.51f)
                close()
                moveTo(5.71f, 18.29f)
                curveToRelative(0.63f, -1.89f, 2.16f, -4.99f, 4.87f, -7.7f)
                curveToRelative(2.68f, -2.68f, 5.78f, -4.23f, 7.7f, -4.88f)
                curveToRelative(-0.63f, 1.89f, -2.16f, 4.99f, -4.88f, 7.7f)
                curveTo(10.74f, 16.09f, 7.64f, 17.64f, 5.71f, 18.29f)
                close()
                moveTo(7.76f, 7.76f)
                curveToRelative(2.64f, -2.64f, 6.34f, -3.12f, 8.03f, -3.19f)
                curveToRelative(-2.05f, 0.94f, -4.46f, 2.46f, -6.61f, 4.61f)
                curveToRelative(-2.16f, 2.16f, -3.67f, 4.58f, -4.61f, 6.63f)
                curveTo(4.66f, 13.33f, 5.44f, 10.07f, 7.76f, 7.76f)
                close()
                moveTo(16.24f, 16.24f)
                curveToRelative(-2.64f, 2.64f, -6.34f, 3.12f, -8.03f, 3.19f)
                curveToRelative(2.05f, -0.94f, 4.46f, -2.46f, 6.61f, -4.61f)
                curveToRelative(2.16f, -2.16f, 3.67f, -4.58f, 4.62f, -6.63f)
                curveTo(19.34f, 10.67f, 18.56f, 13.93f, 16.24f, 16.24f)
                close()
            }
        }
        return _sportsRugby!!
    }

private var _sportsRugby: ImageVector? = null
