/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Thunderstorm: ImageVector
    get() {
        if (_thunderstorm != null) {
            return _thunderstorm!!
        }
        _thunderstorm = materialIcon(name = "TwoTone.Thunderstorm") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.73f, 9.01f)
                lineTo(16.2f, 8.87f)
                lineToRelative(-0.25f, -1.52f)
                curveTo(15.63f, 5.44f, 13.94f, 4.0f, 12.0f, 4.0f)
                curveToRelative(-1.44f, 0.0f, -2.77f, 0.78f, -3.48f, 2.04f)
                lineTo(8.03f, 6.91f)
                lineTo(7.04f, 7.04f)
                curveTo(5.31f, 7.27f, 4.0f, 8.76f, 4.0f, 10.5f)
                curveTo(4.0f, 12.43f, 5.57f, 14.0f, 7.5f, 14.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                curveTo(20.0f, 10.22f, 19.01f, 9.13f, 17.73f, 9.01f)
                close()
            }
            materialPath {
                moveTo(17.92f, 7.02f)
                curveTo(17.45f, 4.18f, 14.97f, 2.0f, 12.0f, 2.0f)
                curveTo(9.82f, 2.0f, 7.83f, 3.18f, 6.78f, 5.06f)
                curveTo(4.09f, 5.41f, 2.0f, 7.74f, 2.0f, 10.5f)
                curveTo(2.0f, 13.53f, 4.47f, 16.0f, 7.5f, 16.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(2.48f, 0.0f, 4.5f, -2.02f, 4.5f, -4.5f)
                curveTo(22.0f, 9.16f, 20.21f, 7.23f, 17.92f, 7.02f)
                close()
                moveTo(17.5f, 14.0f)
                horizontalLineToRelative(-10.0f)
                curveTo(5.57f, 14.0f, 4.0f, 12.43f, 4.0f, 10.5f)
                curveToRelative(0.0f, -1.74f, 1.31f, -3.23f, 3.04f, -3.46f)
                lineToRelative(0.99f, -0.13f)
                lineToRelative(0.49f, -0.87f)
                curveTo(9.23f, 4.78f, 10.56f, 4.0f, 12.0f, 4.0f)
                curveToRelative(1.94f, 0.0f, 3.63f, 1.44f, 3.95f, 3.35f)
                lineToRelative(0.25f, 1.52f)
                lineToRelative(1.54f, 0.14f)
                curveTo(19.01f, 9.13f, 20.0f, 10.22f, 20.0f, 11.5f)
                curveTo(20.0f, 12.88f, 18.88f, 14.0f, 17.5f, 14.0f)
                close()
            }
            materialPath {
                moveTo(14.8f, 17.0f)
                lineToRelative(-2.9f, 3.32f)
                lineToRelative(2.0f, 1.0f)
                lineToRelative(-2.35f, 2.68f)
                lineToRelative(2.65f, 0.0f)
                lineToRelative(2.9f, -3.32f)
                lineToRelative(-2.0f, -1.0f)
                lineToRelative(2.35f, -2.68f)
                close()
            }
            materialPath {
                moveTo(8.8f, 17.0f)
                lineToRelative(-2.9f, 3.32f)
                lineToRelative(2.0f, 1.0f)
                lineToRelative(-2.35f, 2.68f)
                lineToRelative(2.65f, 0.0f)
                lineToRelative(2.9f, -3.32f)
                lineToRelative(-2.0f, -1.0f)
                lineToRelative(2.35f, -2.68f)
                close()
            }
        }
        return _thunderstorm!!
    }

private var _thunderstorm: ImageVector? = null
