/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ViewDay: ImageVector
    get() {
        if (_viewDay != null) {
            return _viewDay!!
        }
        _viewDay = materialIcon(name = "TwoTone.ViewDay") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.0f, 10.0f)
                horizontalLineToRelative(15.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(2.0f, 18.0f)
                horizontalLineToRelative(19.0f)
                verticalLineToRelative(2.0f)
                lineTo(2.0f, 20.0f)
                close()
                moveTo(20.0f, 8.0f)
                lineTo(3.0f, 8.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                lineTo(21.0f, 9.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                close()
                moveTo(19.0f, 14.0f)
                lineTo(4.0f, 14.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(15.0f)
                verticalLineToRelative(4.0f)
                close()
                moveTo(2.0f, 4.0f)
                horizontalLineToRelative(19.0f)
                verticalLineToRelative(2.0f)
                lineTo(2.0f, 6.0f)
                close()
            }
        }
        return _viewDay!!
    }

private var _viewDay: ImageVector? = null
