/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.WbShade: ImageVector
    get() {
        if (_wbShade != null) {
            return _wbShade!!
        }
        _wbShade = materialIcon(name = "TwoTone.WbShade") {
            materialPath {
                moveTo(14.0f, 12.0f)
                verticalLineToRelative(2.5f)
                lineToRelative(5.5f, 5.5f)
                horizontalLineTo(22.0f)
                lineTo(14.0f, 12.0f)
                close()
                moveTo(14.0f, 20.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(-3.0f, -3.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(8.0f, 4.0f)
                lineToRelative(-6.0f, 6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(2.0f)
                lineTo(8.0f, 4.0f)
                close()
                moveTo(9.0f, 14.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(14.0f)
                close()
            }
        }
        return _wbShade!!
    }

private var _wbShade: ImageVector? = null
