/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Workspaces: ImageVector
    get() {
        if (_workspaces != null) {
            return _workspaces!!
        }
        _workspaces = materialIcon(name = "TwoTone.Workspaces") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.0f, 17.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 7.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.0f, 17.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
            materialPath {
                moveTo(18.0f, 13.0f)
                curveToRelative(-2.2f, 0.0f, -4.0f, 1.8f, -4.0f, 4.0f)
                reflectiveCurveToRelative(1.8f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.8f, 4.0f, -4.0f)
                reflectiveCurveTo(20.2f, 13.0f, 18.0f, 13.0f)
                close()
                moveTo(18.0f, 19.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(20.0f, 18.1f, 19.1f, 19.0f, 18.0f, 19.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 13.0f)
                curveToRelative(-2.2f, 0.0f, -4.0f, 1.8f, -4.0f, 4.0f)
                reflectiveCurveToRelative(1.8f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.8f, 4.0f, -4.0f)
                reflectiveCurveTo(8.2f, 13.0f, 6.0f, 13.0f)
                close()
                moveTo(6.0f, 19.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(8.0f, 18.1f, 7.1f, 19.0f, 6.0f, 19.0f)
                close()
            }
            materialPath {
                moveTo(16.0f, 7.0f)
                curveToRelative(0.0f, -2.2f, -1.8f, -4.0f, -4.0f, -4.0f)
                reflectiveCurveTo(8.0f, 4.8f, 8.0f, 7.0f)
                reflectiveCurveToRelative(1.8f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveTo(16.0f, 9.2f, 16.0f, 7.0f)
                close()
                moveTo(12.0f, 9.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                curveTo(14.0f, 8.1f, 13.1f, 9.0f, 12.0f, 9.0f)
                close()
            }
        }
        return _workspaces!!
    }

private var _workspaces: ImageVector? = null
