/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.CalendarModel_androidKt;
import androidx.compose.material3.DatePickerFormatter;
import androidx.compose.runtime.Immutable;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J-\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u0004\u0018\u00010\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001c"}, d2={"Landroidx/compose/material3/DatePickerFormatterImpl;", "Landroidx/compose/material3/DatePickerFormatter;", "yearSelectionSkeleton", "", "selectedDateSkeleton", "selectedDateDescriptionSkeleton", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getSelectedDateDescriptionSkeleton", "()Ljava/lang/String;", "getSelectedDateSkeleton", "getYearSelectionSkeleton", "equals", "", "other", "", "formatDate", "dateMillis", "", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "forContentDescription", "(Ljava/lang/Long;Ljava/util/Locale;Z)Ljava/lang/String;", "formatMonthYear", "monthMillis", "(Ljava/lang/Long;Ljava/util/Locale;)Ljava/lang/String;", "hashCode", "", "material3_release"})
@Immutable
final class DatePickerFormatterImpl
implements DatePickerFormatter {
    @NotNull
    private final String yearSelectionSkeleton;
    @NotNull
    private final String selectedDateSkeleton;
    @NotNull
    private final String selectedDateDescriptionSkeleton;

    public DatePickerFormatterImpl(@NotNull String yearSelectionSkeleton, @NotNull String selectedDateSkeleton, @NotNull String selectedDateDescriptionSkeleton) {
        this.yearSelectionSkeleton = yearSelectionSkeleton;
        this.selectedDateSkeleton = selectedDateSkeleton;
        this.selectedDateDescriptionSkeleton = selectedDateDescriptionSkeleton;
    }

    @NotNull
    public final String getYearSelectionSkeleton() {
        return this.yearSelectionSkeleton;
    }

    @NotNull
    public final String getSelectedDateSkeleton() {
        return this.selectedDateSkeleton;
    }

    @NotNull
    public final String getSelectedDateDescriptionSkeleton() {
        return this.selectedDateDescriptionSkeleton;
    }

    @Override
    @Nullable
    public String formatMonthYear(@Nullable Long monthMillis, @NotNull Locale locale) {
        if (monthMillis == null) {
            return null;
        }
        return CalendarModel_androidKt.formatWithSkeleton(monthMillis, this.yearSelectionSkeleton, locale);
    }

    @Override
    @Nullable
    public String formatDate(@Nullable Long dateMillis, @NotNull Locale locale, boolean forContentDescription) {
        if (dateMillis == null) {
            return null;
        }
        return CalendarModel_androidKt.formatWithSkeleton(dateMillis, forContentDescription ? this.selectedDateDescriptionSkeleton : this.selectedDateSkeleton, locale);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DatePickerFormatterImpl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.yearSelectionSkeleton, (Object)((DatePickerFormatterImpl)other).yearSelectionSkeleton)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.selectedDateSkeleton, (Object)((DatePickerFormatterImpl)other).selectedDateSkeleton)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.selectedDateDescriptionSkeleton, (Object)((DatePickerFormatterImpl)other).selectedDateDescriptionSkeleton);
    }

    public int hashCode() {
        int result2 = this.yearSelectionSkeleton.hashCode();
        result2 = 31 * result2 + this.selectedDateSkeleton.hashCode();
        result2 = 31 * result2 + this.selectedDateDescriptionSkeleton.hashCode();
        return result2;
    }
}

