/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.collection.IntIntMap;
import androidx.collection.IntIntMapKt;
import androidx.collection.MutableIntIntMap;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.Strategy;
import java.util.List;
import kotlin.Metadata;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\t"}, d2={"KeylineSnapPosition", "Landroidx/compose/foundation/gestures/snapping/SnapPosition;", "snapPositions", "Landroidx/collection/IntIntMap;", "calculateSnapPositions", "strategy", "Landroidx/compose/material3/carousel/Strategy;", "itemCount", "", "material3_release"})
public final class KeylineSnapPositionKt {
    @NotNull
    public static final IntIntMap calculateSnapPositions(@Nullable Strategy strategy, int itemCount) {
        if (strategy == null || !strategy.isValid()) {
            return IntIntMapKt.emptyIntIntMap();
        }
        MutableIntIntMap map2 = IntIntMapKt.mutableIntIntMapOf();
        KeylineList defaultKeylines = strategy.getDefaultKeylines$material3_release();
        List<KeylineList> startKeylineSteps = strategy.getStartKeylineSteps$material3_release();
        List<KeylineList> endKeylineSteps = strategy.getEndKeylineSteps$material3_release();
        int numOfFocalKeylines = defaultKeylines.getLastFocalIndex() - defaultKeylines.getFirstFocalIndex();
        int startStepsSize = startKeylineSteps.size() + numOfFocalKeylines;
        int endStepsSize = endKeylineSteps.size() + numOfFocalKeylines;
        for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            map2.set(itemIndex, 0);
            if (itemIndex < startStepsSize) {
                int startIndex = Math.max(0, startStepsSize - 1 - itemIndex);
                startIndex = Math.min(startKeylineSteps.size() - 1, startIndex);
                KeylineList startKeylines = startKeylineSteps.get(startIndex);
                map2.set(itemIndex, MathKt.roundToInt((float)(startKeylines.getFirstFocal().getOffset() - startKeylines.getFirstFocal().getSize() / 2.0f)));
                continue;
            }
            if (itemIndex >= itemCount - endStepsSize) {
                int endIndex = Math.max(0, itemIndex - itemCount + endStepsSize);
                endIndex = Math.min(endKeylineSteps.size() - 1, endIndex);
                KeylineList endKeylines = endKeylineSteps.get(endIndex);
                map2.set(itemIndex, MathKt.roundToInt((float)(endKeylines.getFirstFocal().getOffset() - endKeylines.getFirstFocal().getSize() / 2.0f)));
                continue;
            }
            map2.set(itemIndex, MathKt.roundToInt((float)(defaultKeylines.getFirstFocal().getOffset() - defaultKeylines.getFirstFocal().getSize() / 2.0f)));
        }
        return (IntIntMap)map2;
    }

    @NotNull
    public static final SnapPosition KeylineSnapPosition(@NotNull IntIntMap snapPositions) {
        return new SnapPosition(snapPositions){
            final /* synthetic */ IntIntMap $snapPositions;
            {
                this.$snapPositions = $snapPositions;
            }

            public int position(int layoutSize, int itemSize, int beforeContentPadding, int afterContentPadding, int itemIndex, int itemCount) {
                return this.$snapPositions.getSize() > 0 ? this.$snapPositions.get(itemIndex) : 0;
            }
        };
    }
}

