/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.material3.carousel.CarouselAlignment;
import androidx.compose.material3.carousel.Keyline;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListScope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JL\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\b\u0010\u001e\u001a\u00020\u0004H\u0002J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J \u0010!\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006#"}, d2={"Landroidx/compose/material3/carousel/KeylineListScopeImpl;", "Landroidx/compose/material3/carousel/KeylineListScope;", "()V", "firstFocalIndex", "", "focalItemSize", "", "pivotIndex", "pivotOffset", "tmpKeylines", "", "Landroidx/compose/material3/carousel/KeylineListScopeImpl$TmpKeyline;", "add", "", "size", "isAnchor", "", "createKeylinesWithPivot", "", "Landroidx/compose/material3/carousel/Keyline;", "lastFocalIndex", "itemMainAxisSize", "carouselMainAxisSize", "createWithAlignment", "Landroidx/compose/material3/carousel/KeylineList;", "carouselAlignment", "Landroidx/compose/material3/carousel/CarouselAlignment;", "createWithAlignment-nm_8Vhk", "(FI)Landroidx/compose/material3/carousel/KeylineList;", "createWithPivot", "findLastFocalIndex", "isCutoffLeft", "offset", "isCutoffRight", "TmpKeyline", "material3_release"})
@SourceDebugExtension(value={"SMAP\nKeylineList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeylineList.kt\nandroidx/compose/material3/carousel/KeylineListScopeImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,529:1\n1855#2,2:530\n1855#2,2:532\n*S KotlinDebug\n*F\n+ 1 KeylineList.kt\nandroidx/compose/material3/carousel/KeylineListScopeImpl\n*L\n411#1:530,2\n438#1:532,2\n*E\n"})
final class KeylineListScopeImpl
implements KeylineListScope {
    private int firstFocalIndex = -1;
    private float focalItemSize;
    private int pivotIndex = -1;
    private float pivotOffset;
    @NotNull
    private final List<TmpKeyline> tmpKeylines = new ArrayList();

    @Override
    public void add(float size, boolean isAnchor) {
        this.tmpKeylines.add(new TmpKeyline(size, isAnchor));
        if (size > this.focalItemSize) {
            this.firstFocalIndex = CollectionsKt.getLastIndex(this.tmpKeylines);
            this.focalItemSize = size;
        }
    }

    @NotNull
    public final KeylineList createWithPivot(float carouselMainAxisSize, int pivotIndex, float pivotOffset) {
        List<Keyline> keylines = this.createKeylinesWithPivot(pivotIndex, pivotOffset, this.firstFocalIndex, this.findLastFocalIndex(), this.focalItemSize, carouselMainAxisSize, this.tmpKeylines);
        return new KeylineList(keylines);
    }

    @NotNull
    public final KeylineList createWithAlignment-nm_8Vhk(float carouselMainAxisSize, int carouselAlignment) {
        int lastFocalIndex = this.findLastFocalIndex();
        int focalItemCount = lastFocalIndex - this.firstFocalIndex;
        this.pivotIndex = this.firstFocalIndex;
        int n = carouselAlignment;
        this.pivotOffset = CarouselAlignment.equals-impl0(n, CarouselAlignment.Companion.getCenter-NUL3oTo()) ? carouselMainAxisSize / (float)2 - this.focalItemSize / (float)2 * (float)focalItemCount : (CarouselAlignment.equals-impl0(n, CarouselAlignment.Companion.getEnd-NUL3oTo()) ? carouselMainAxisSize - this.focalItemSize / (float)2 : this.focalItemSize / (float)2);
        List<Keyline> keylines = this.createKeylinesWithPivot(this.pivotIndex, this.pivotOffset, this.firstFocalIndex, lastFocalIndex, this.focalItemSize, carouselMainAxisSize, this.tmpKeylines);
        return new KeylineList(keylines);
    }

    private final int findLastFocalIndex() {
        int lastFocalIndex;
        for (lastFocalIndex = this.firstFocalIndex; lastFocalIndex < CollectionsKt.getLastIndex(this.tmpKeylines) && this.tmpKeylines.get(lastFocalIndex + 1).getSize() == this.focalItemSize; ++lastFocalIndex) {
        }
        return lastFocalIndex;
    }

    private final List<Keyline> createKeylinesWithPivot(int pivotIndex, float pivotOffset, int firstFocalIndex, int lastFocalIndex, float itemMainAxisSize, float carouselMainAxisSize, List<TmpKeyline> tmpKeylines) {
        float cutoff;
        float tmpUnadjustedOffset;
        float tmpOffset;
        TmpKeyline tmp;
        int originalIndex;
        int element$iv;
        TmpKeyline pivot = tmpKeylines.get(pivotIndex);
        List keylines = new ArrayList();
        float pivotCutoff = this.isCutoffLeft(pivot.getSize(), pivotOffset) ? pivotOffset - pivot.getSize() / (float)2 : (this.isCutoffRight(pivot.getSize(), pivotOffset, carouselMainAxisSize) ? pivotOffset + pivot.getSize() / (float)2 - carouselMainAxisSize : 0.0f);
        keylines.add(new Keyline(pivot.getSize(), pivotOffset, pivotOffset, firstFocalIndex <= pivotIndex ? pivotIndex <= lastFocalIndex : false, pivot.isAnchor(), true, pivotCutoff));
        float offset2 = 0.0f;
        offset2 = pivotOffset - itemMainAxisSize / (float)2;
        float unadjustedOffset = 0.0f;
        unadjustedOffset = pivotOffset - itemMainAxisSize / (float)2;
        Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)(pivotIndex - 1), (int)0);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            originalIndex = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            tmp = tmpKeylines.get(originalIndex);
            tmpOffset = offset2 - tmp.getSize() / (float)2;
            tmpUnadjustedOffset = unadjustedOffset - itemMainAxisSize / (float)2;
            cutoff = this.isCutoffLeft(tmp.getSize(), tmpOffset) ? Math.abs(tmpOffset - tmp.getSize() / (float)2) : 0.0f;
            keylines.add(0, new Keyline(tmp.getSize(), tmpOffset, tmpUnadjustedOffset, firstFocalIndex <= originalIndex ? originalIndex <= lastFocalIndex : false, tmp.isAnchor(), false, cutoff));
            offset2 -= tmp.getSize();
            unadjustedOffset -= itemMainAxisSize;
        }
        offset2 = pivotOffset + itemMainAxisSize / (float)2;
        unadjustedOffset = pivotOffset + itemMainAxisSize / (float)2;
        $this$forEach$iv = (Iterable)RangesKt.until((int)(pivotIndex + 1), (int)tmpKeylines.size());
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            originalIndex = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            tmp = tmpKeylines.get(originalIndex);
            tmpOffset = offset2 + tmp.getSize() / (float)2;
            tmpUnadjustedOffset = unadjustedOffset + itemMainAxisSize / (float)2;
            cutoff = this.isCutoffRight(tmp.getSize(), tmpOffset, carouselMainAxisSize) ? tmpOffset + tmp.getSize() / (float)2 - carouselMainAxisSize : 0.0f;
            keylines.add(new Keyline(tmp.getSize(), tmpOffset, tmpUnadjustedOffset, firstFocalIndex <= originalIndex ? originalIndex <= lastFocalIndex : false, tmp.isAnchor(), false, cutoff));
            offset2 += tmp.getSize();
            unadjustedOffset += itemMainAxisSize;
        }
        return keylines;
    }

    private final boolean isCutoffLeft(float size, float offset2) {
        return offset2 - size / (float)2 < 0.0f && offset2 + size / (float)2 > 0.0f;
    }

    private final boolean isCutoffRight(float size, float offset2, float carouselMainAxisSize) {
        return offset2 - size / (float)2 < carouselMainAxisSize && offset2 + size / (float)2 > carouselMainAxisSize;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Landroidx/compose/material3/carousel/KeylineListScopeImpl$TmpKeyline;", "", "size", "", "isAnchor", "", "(FZ)V", "()Z", "getSize", "()F", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "material3_release"})
    private static final class TmpKeyline {
        private final float size;
        private final boolean isAnchor;

        public TmpKeyline(float size, boolean isAnchor) {
            this.size = size;
            this.isAnchor = isAnchor;
        }

        public final float getSize() {
            return this.size;
        }

        public final boolean isAnchor() {
            return this.isAnchor;
        }

        public final float component1() {
            return this.size;
        }

        public final boolean component2() {
            return this.isAnchor;
        }

        @NotNull
        public final TmpKeyline copy(float size, boolean isAnchor) {
            return new TmpKeyline(size, isAnchor);
        }

        public static /* synthetic */ TmpKeyline copy$default(TmpKeyline tmpKeyline, float f, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                f = tmpKeyline.size;
            }
            if ((n & 2) != 0) {
                bl = tmpKeyline.isAnchor;
            }
            return tmpKeyline.copy(f, bl);
        }

        @NotNull
        public String toString() {
            return "TmpKeyline(size=" + this.size + ", isAnchor=" + this.isAnchor + ')';
        }

        public int hashCode() {
            int result = Float.hashCode(this.size);
            result = result * 31 + Boolean.hashCode(this.isAnchor);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TmpKeyline)) {
                return false;
            }
            TmpKeyline tmpKeyline = (TmpKeyline)other;
            if (Float.compare(this.size, tmpKeyline.size) != 0) {
                return false;
            }
            return this.isAnchor == tmpKeyline.isAnchor;
        }
    }
}

