/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.collection.IntIntMap;
import androidx.collection.IntIntMapKt;
import androidx.collection.MutableIntIntMap;
import androidx.compose.animation.SplineBasedFloatDecayAnimationSpec_androidKt;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecKt;
import androidx.compose.foundation.gestures.TargetedFlingBehavior;
import androidx.compose.foundation.gestures.snapping.SnapFlingBehaviorKt;
import androidx.compose.foundation.gestures.snapping.SnapLayoutInfoProvider;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.material3.ExperimentalMaterial3Api;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineSnapPositionKt;
import androidx.compose.material3.carousel.Strategy;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001a\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\r\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"KeylineSnapPosition", "Landroidx/compose/foundation/gestures/snapping/SnapPosition;", "snapPositions", "Landroidx/collection/IntIntMap;", "calculateSnapPositions", "strategy", "Landroidx/compose/material3/carousel/Strategy;", "itemCount", "", "rememberDecaySnapFlingBehavior", "Landroidx/compose/foundation/gestures/TargetedFlingBehavior;", "(Landroidx/compose/runtime/Composer;I)Landroidx/compose/foundation/gestures/TargetedFlingBehavior;", "material3_release"})
@SourceDebugExtension(value={"SMAP\nKeylineSnapPosition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeylineSnapPosition.kt\nandroidx/compose/material3/carousel/KeylineSnapPositionKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,105:1\n1173#2,6:106\n*S KotlinDebug\n*F\n+ 1 KeylineSnapPosition.kt\nandroidx/compose/material3/carousel/KeylineSnapPositionKt\n*L\n93#1:106,6\n*E\n"})
public final class KeylineSnapPositionKt {
    @NotNull
    public static final IntIntMap calculateSnapPositions(@Nullable Strategy strategy, int itemCount) {
        if (strategy == null || !strategy.isValid()) {
            return IntIntMapKt.emptyIntIntMap();
        }
        MutableIntIntMap map2 = IntIntMapKt.mutableIntIntMapOf();
        KeylineList defaultKeylines = strategy.getDefaultKeylines$material3_release();
        List<KeylineList> startKeylineSteps = strategy.getStartKeylineSteps$material3_release();
        List<KeylineList> endKeylineSteps = strategy.getEndKeylineSteps$material3_release();
        int numOfFocalKeylines = defaultKeylines.getLastFocalIndex() - defaultKeylines.getFirstFocalIndex();
        int startStepsSize = startKeylineSteps.size() + numOfFocalKeylines;
        int endStepsSize = endKeylineSteps.size() + numOfFocalKeylines;
        for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            map2.set(itemIndex, MathKt.roundToInt((float)(defaultKeylines.getFirstFocal().getOffset() - defaultKeylines.getFirstFocal().getSize() / 2.0f)));
            if (itemIndex < startStepsSize) {
                int startIndex = Math.max(0, startStepsSize - 1 - itemIndex);
                startIndex = Math.min(startKeylineSteps.size() - 1, startIndex);
                KeylineList startKeylines = startKeylineSteps.get(startIndex);
                map2.set(itemIndex, MathKt.roundToInt((float)(startKeylines.getFirstFocal().getOffset() - startKeylines.getFirstFocal().getSize() / 2.0f)));
            }
            if (itemCount <= numOfFocalKeylines + 1 || itemIndex < itemCount - endStepsSize) continue;
            int endIndex = Math.max(0, itemIndex - itemCount + endStepsSize);
            endIndex = Math.min(endKeylineSteps.size() - 1, endIndex);
            KeylineList endKeylines = endKeylineSteps.get(endIndex);
            map2.set(itemIndex, MathKt.roundToInt((float)(endKeylines.getFirstFocal().getOffset() - endKeylines.getFirstFocal().getSize() / 2.0f)));
        }
        return (IntIntMap)map2;
    }

    @NotNull
    public static final SnapPosition KeylineSnapPosition(@NotNull IntIntMap snapPositions) {
        return new SnapPosition(snapPositions){
            final /* synthetic */ IntIntMap $snapPositions;
            {
                this.$snapPositions = $snapPositions;
            }

            public int position(int layoutSize, int itemSize, int beforeContentPadding, int afterContentPadding, int itemIndex, int itemCount) {
                return this.$snapPositions.getSize() > 0 ? this.$snapPositions.get(itemIndex) : 0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalMaterial3Api
    @Composable
    @NotNull
    public static final TargetedFlingBehavior rememberDecaySnapFlingBehavior(@Nullable Composer $composer, int $changed) {
        Object object;
        void $this$cache$iv;
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)178504446, (String)"C(rememberDecaySnapFlingBehavior)91@3926L33,92@3994L327,102@4334L75:KeylineSnapPosition.kt#dcf9yb");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)178504446, (int)$changed, (int)-1, (String)"androidx.compose.material3.carousel.rememberDecaySnapFlingBehavior (KeylineSnapPosition.kt:90)");
        }
        DecayAnimationSpec splineDecay = SplineBasedFloatDecayAnimationSpec_androidKt.rememberSplineBasedDecay((Composer)$composer, (int)0);
        ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)-296763848, (String)"CC(remember):KeylineSnapPosition.kt#9igjgp");
        Composer composer = $composer;
        boolean invalid$iv = false;
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl = false;
        if (it$iv == Composer.Companion.getEmpty()) {
            boolean bl2 = false;
            SnapLayoutInfoProvider value$iv = new SnapLayoutInfoProvider((DecayAnimationSpec<Float>)splineDecay){
                final /* synthetic */ DecayAnimationSpec<Float> $splineDecay;
                {
                    this.$splineDecay = $splineDecay;
                }

                public float calculateApproachOffset(float initialVelocity) {
                    return DecayAnimationSpecKt.calculateTargetValue(this.$splineDecay, (float)0.0f, (float)initialVelocity);
                }

                public float calculateSnappingOffset(float currentVelocity) {
                    return 0.0f;
                }
            };
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        rememberDecaySnapFlingBehavior.decayLayoutInfoProvider.1.1 var4_10 = object;
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        rememberDecaySnapFlingBehavior.decayLayoutInfoProvider.1.1 decayLayoutInfoProvider2 = var4_10;
        var4_10 = SnapFlingBehaviorKt.rememberSnapFlingBehavior((SnapLayoutInfoProvider)decayLayoutInfoProvider2, (Composer)$composer, (int)6);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
        return var4_10;
    }
}

