/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.annotation.VisibleForTesting;
import androidx.collection.FloatList;
import androidx.collection.FloatListKt;
import androidx.collection.MutableFloatList;
import androidx.compose.material3.carousel.Keyline;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListKt;
import androidx.compose.material3.carousel.KeylineListScope;
import androidx.compose.material3.carousel.StrategyKt;
import androidx.compose.runtime.FloatState;
import androidx.compose.runtime.MutableFloatState;
import androidx.compose.runtime.PrimitiveSnapshotStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B*\u0012#\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0015\u0010%\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b&J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\r\u0010*\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b+J'\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u00042\b\b\u0002\u0010/\u001a\u00020(H\u0000\u00a2\u0006\u0002\b0J\r\u00101\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b2J\b\u00103\u001a\u000204H\u0016J\u0006\u00105\u001a\u00020(R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\bX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00048@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010\u0002\u001a\u001f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\u000e\u0010#\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Landroidx/compose/material3/carousel/Strategy;", "", "keylineList", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "availableSpace", "Landroidx/compose/material3/carousel/KeylineList;", "(Lkotlin/jvm/functions/Function1;)V", "defaultKeylines", "getDefaultKeylines$material3_release", "()Landroidx/compose/material3/carousel/KeylineList;", "setDefaultKeylines$material3_release", "(Landroidx/compose/material3/carousel/KeylineList;)V", "endKeylineSteps", "", "getEndKeylineSteps$material3_release", "()Ljava/util/List;", "setEndKeylineSteps$material3_release", "(Ljava/util/List;)V", "endShiftDistance", "endShiftPoints", "Landroidx/collection/FloatList;", "<set-?>", "itemMainAxisSize", "getItemMainAxisSize$material3_release", "()F", "setItemMainAxisSize$material3_release", "(F)V", "itemMainAxisSize$delegate", "Landroidx/compose/runtime/MutableFloatState;", "startKeylineSteps", "getStartKeylineSteps$material3_release", "setStartKeylineSteps$material3_release", "startShiftDistance", "startShiftPoints", "apply", "apply$material3_release", "equals", "", "other", "getEndKeylines", "getEndKeylines$material3_release", "getKeylineListForScrollOffset", "scrollOffset", "maxScrollOffset", "roundToNearestStep", "getKeylineListForScrollOffset$material3_release", "getStartKeylines", "getStartKeylines$material3_release", "hashCode", "", "isValid", "Companion", "material3_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/Strategy\n+ 2 SnapshotFloatState.kt\nandroidx/compose/runtime/PrimitiveSnapshotStateKt__SnapshotFloatStateKt\n*L\n1#1,539:1\n76#2:540\n109#2,2:541\n*S KotlinDebug\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/Strategy\n*L\n97#1:540\n97#1:541,2\n*E\n"})
public final class Strategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Float, KeylineList> keylineList;
    public KeylineList defaultKeylines;
    public List<KeylineList> startKeylineSteps;
    public List<KeylineList> endKeylineSteps;
    private float startShiftDistance;
    private float endShiftDistance;
    private FloatList startShiftPoints;
    private FloatList endShiftPoints;
    private float availableSpace;
    @NotNull
    private final MutableFloatState itemMainAxisSize$delegate;
    public static final int $stable = 8;

    public Strategy(@NotNull Function1<? super Float, KeylineList> keylineList) {
        this.keylineList = keylineList;
        this.itemMainAxisSize$delegate = PrimitiveSnapshotStateKt.mutableFloatStateOf((float)0.0f);
    }

    @NotNull
    public final KeylineList getDefaultKeylines$material3_release() {
        KeylineList keylineList = this.defaultKeylines;
        if (keylineList != null) {
            return keylineList;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"defaultKeylines");
        return null;
    }

    public final void setDefaultKeylines$material3_release(@NotNull KeylineList keylineList) {
        this.defaultKeylines = keylineList;
    }

    @NotNull
    public final List<KeylineList> getStartKeylineSteps$material3_release() {
        List<KeylineList> list = this.startKeylineSteps;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"startKeylineSteps");
        return null;
    }

    public final void setStartKeylineSteps$material3_release(@NotNull List<KeylineList> list) {
        this.startKeylineSteps = list;
    }

    @NotNull
    public final List<KeylineList> getEndKeylineSteps$material3_release() {
        List<KeylineList> list = this.endKeylineSteps;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"endKeylineSteps");
        return null;
    }

    public final void setEndKeylineSteps$material3_release(@NotNull List<KeylineList> list) {
        this.endKeylineSteps = list;
    }

    /*
     * WARNING - void declaration
     */
    public final float getItemMainAxisSize$material3_release() {
        void $this$getValue$iv;
        FloatState floatState = (FloatState)this.itemMainAxisSize$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return $this$getValue$iv.getFloatValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setItemMainAxisSize$material3_release(float f) {
        void $this$setValue$iv;
        MutableFloatState mutableFloatState = this.itemMainAxisSize$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setFloatValue(f);
    }

    public final boolean isValid() {
        return this.getItemMainAxisSize$material3_release() > 0.0f;
    }

    @NotNull
    public final Strategy apply$material3_release(float availableSpace) {
        if (this.availableSpace == availableSpace) {
            return this;
        }
        KeylineList keylineList = (KeylineList)this.keylineList.invoke((Object)Float.valueOf(availableSpace));
        if (keylineList == null) {
            return this;
        }
        KeylineList keylineList2 = keylineList;
        List startKeylineSteps = Strategy.Companion.getStartKeylineSteps(keylineList2, availableSpace);
        List endKeylineSteps = Strategy.Companion.getEndKeylineSteps(keylineList2, availableSpace);
        float startShiftDistance = ((Keyline)CollectionsKt.first((List)((List)CollectionsKt.last((List)startKeylineSteps)))).getUnadjustedOffset() - ((Keyline)CollectionsKt.first((List)keylineList2)).getUnadjustedOffset();
        float endShiftDistance = ((Keyline)CollectionsKt.last((List)keylineList2)).getUnadjustedOffset() - ((Keyline)CollectionsKt.last((List)((List)CollectionsKt.last((List)endKeylineSteps)))).getUnadjustedOffset();
        this.setDefaultKeylines$material3_release(keylineList2);
        this.setDefaultKeylines$material3_release(keylineList2);
        this.setStartKeylineSteps$material3_release(startKeylineSteps);
        this.setEndKeylineSteps$material3_release(endKeylineSteps);
        this.startShiftDistance = startShiftDistance;
        this.endShiftDistance = endShiftDistance;
        this.startShiftPoints = Strategy.Companion.getStepInterpolationPoints(startShiftDistance, startKeylineSteps, true);
        this.endShiftPoints = Strategy.Companion.getStepInterpolationPoints(endShiftDistance, endKeylineSteps, false);
        this.availableSpace = availableSpace;
        this.setItemMainAxisSize$material3_release(this.getDefaultKeylines$material3_release().getFirstFocal().getSize());
        return this;
    }

    @NotNull
    public final KeylineList getKeylineListForScrollOffset$material3_release(float scrollOffset, float maxScrollOffset, boolean roundToNearestStep) {
        float positiveScrollOffset = Math.max(0.0f, scrollOffset);
        float startShiftOffset = this.startShiftDistance;
        float endShiftOffset = Math.max(0.0f, maxScrollOffset - this.endShiftDistance);
        boolean bl = startShiftOffset <= positiveScrollOffset ? positiveScrollOffset <= endShiftOffset : false;
        if (bl) {
            return this.getDefaultKeylines$material3_release();
        }
        float interpolation = StrategyKt.access$lerp(1.0f, 0.0f, 0.0f, startShiftOffset, positiveScrollOffset);
        FloatList floatList = this.startShiftPoints;
        if (floatList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startShiftPoints");
            floatList = null;
        }
        FloatList shiftPoints = floatList;
        List<KeylineList> steps = this.getStartKeylineSteps$material3_release();
        if (positiveScrollOffset > endShiftOffset) {
            interpolation = StrategyKt.access$lerp(0.0f, 1.0f, endShiftOffset, maxScrollOffset, positiveScrollOffset);
            FloatList floatList2 = this.endShiftPoints;
            if (floatList2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"endShiftPoints");
                floatList2 = null;
            }
            shiftPoints = floatList2;
            steps = this.getEndKeylineSteps$material3_release();
        }
        Companion.ShiftPointRange shiftPointRange = Strategy.Companion.getShiftPointRange(steps.size(), shiftPoints, interpolation);
        if (roundToNearestStep) {
            int roundedStepIndex = MathKt.roundToInt((float)shiftPointRange.getSteppedInterpolation()) == 0 ? shiftPointRange.getFromStepIndex() : shiftPointRange.getToStepIndex();
            return steps.get(roundedStepIndex);
        }
        return KeylineListKt.lerp(steps.get(shiftPointRange.getFromStepIndex()), steps.get(shiftPointRange.getToStepIndex()), shiftPointRange.getSteppedInterpolation());
    }

    public static /* synthetic */ KeylineList getKeylineListForScrollOffset$material3_release$default(Strategy strategy, float f, float f2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return strategy.getKeylineListForScrollOffset$material3_release(f, f2, bl);
    }

    @VisibleForTesting
    @NotNull
    public final KeylineList getEndKeylines$material3_release() {
        return (KeylineList)CollectionsKt.last(this.getEndKeylineSteps$material3_release());
    }

    @VisibleForTesting
    @NotNull
    public final KeylineList getStartKeylines$material3_release() {
        return (KeylineList)CollectionsKt.last(this.getStartKeylineSteps$material3_release());
    }

    public boolean equals(@Nullable Object other) {
        FloatList floatList;
        FloatList floatList2;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Strategy)) {
            return false;
        }
        if (!this.isValid() && !((Strategy)other).isValid()) {
            return true;
        }
        if (this.isValid() != ((Strategy)other).isValid()) {
            return false;
        }
        if (!(this.availableSpace == ((Strategy)other).availableSpace)) {
            return false;
        }
        if (!(this.getItemMainAxisSize$material3_release() == ((Strategy)other).getItemMainAxisSize$material3_release())) {
            return false;
        }
        if (!(this.startShiftDistance == ((Strategy)other).startShiftDistance)) {
            return false;
        }
        if (!(this.endShiftDistance == ((Strategy)other).endShiftDistance)) {
            return false;
        }
        FloatList floatList3 = this.startShiftPoints;
        if (floatList3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startShiftPoints");
            floatList3 = null;
        }
        if ((floatList2 = ((Strategy)other).startShiftPoints) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startShiftPoints");
            floatList2 = null;
        }
        if (!Intrinsics.areEqual((Object)floatList3, (Object)floatList2)) {
            return false;
        }
        FloatList floatList4 = this.endShiftPoints;
        if (floatList4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endShiftPoints");
            floatList4 = null;
        }
        if ((floatList = ((Strategy)other).endShiftPoints) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endShiftPoints");
            floatList = null;
        }
        if (!Intrinsics.areEqual((Object)floatList4, (Object)floatList)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getDefaultKeylines$material3_release(), (Object)((Strategy)other).getDefaultKeylines$material3_release());
    }

    public int hashCode() {
        if (!this.isValid()) {
            return Boolean.hashCode(this.isValid());
        }
        int result = Boolean.hashCode(this.isValid());
        result = 31 * result + Float.hashCode(this.availableSpace);
        result = 31 * result + Float.hashCode(this.getItemMainAxisSize$material3_release());
        result = 31 * result + Float.hashCode(this.startShiftDistance);
        result = 31 * result + Float.hashCode(this.endShiftDistance);
        FloatList floatList = this.startShiftPoints;
        if (floatList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startShiftPoints");
            floatList = null;
        }
        result = 31 * result + floatList.hashCode();
        FloatList floatList2 = this.endShiftPoints;
        if (floatList2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"endShiftPoints");
            floatList2 = null;
        }
        result = 31 * result + floatList2.hashCode();
        result = 31 * result + this.getDefaultKeylines$material3_release().hashCode();
        return result;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002\u00a8\u0006\u001e"}, d2={"Landroidx/compose/material3/carousel/Strategy$Companion;", "", "()V", "getEndKeylineSteps", "", "Landroidx/compose/material3/carousel/KeylineList;", "defaultKeylines", "carouselMainAxisSize", "", "getShiftPointRange", "Landroidx/compose/material3/carousel/Strategy$Companion$ShiftPointRange;", "stepsCount", "", "shiftPoint", "Landroidx/collection/FloatList;", "interpolation", "getStartKeylineSteps", "getStepInterpolationPoints", "totalShiftDistance", "steps", "isShiftingLeft", "", "moveKeylineAndCreateShiftedKeylineList", "from", "srcIndex", "dstIndex", "move", "", "Landroidx/compose/material3/carousel/Keyline;", "ShiftPointRange", "material3_release"})
    @SourceDebugExtension(value={"SMAP\nStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/Strategy$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,539:1\n1549#2:540\n1620#2,3:541\n1855#2,2:544\n*S KotlinDebug\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/Strategy$Companion\n*L\n470#1:540\n470#1:541,3\n497#1:544,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<KeylineList> getStartKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize) {
            List steps = new ArrayList();
            steps.add(defaultKeylines);
            if (defaultKeylines.isFirstFocalItemAtStartOfContainer()) {
                return steps;
            }
            int startIndex = defaultKeylines.getFirstNonAnchorIndex();
            int endIndex = defaultKeylines.getFirstFocalIndex();
            int numberOfSteps = endIndex - startIndex;
            if (numberOfSteps <= 0 && defaultKeylines.getFirstFocal().getCutoff() > 0.0f) {
                steps.add(this.moveKeylineAndCreateShiftedKeylineList(defaultKeylines, 0, 0, carouselMainAxisSize));
                return steps;
            }
            for (int i = 0; i < numberOfSteps; ++i) {
                KeylineList prevStep = (KeylineList)CollectionsKt.last((List)steps);
                int originalItemIndex = startIndex + i;
                int dstIndex = CollectionsKt.getLastIndex((List)defaultKeylines);
                if (originalItemIndex > 0) {
                    float originalNeighborBeforeSize = defaultKeylines.get(originalItemIndex - 1).getSize();
                    dstIndex = prevStep.firstIndexAfterFocalRangeWithSize(originalNeighborBeforeSize) - 1;
                }
                steps.add(this.moveKeylineAndCreateShiftedKeylineList(prevStep, defaultKeylines.getFirstNonAnchorIndex(), dstIndex, carouselMainAxisSize));
            }
            return steps;
        }

        private final List<KeylineList> getEndKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize) {
            List steps = new ArrayList();
            steps.add(defaultKeylines);
            if (defaultKeylines.isLastFocalItemAtEndOfContainer(carouselMainAxisSize)) {
                return steps;
            }
            int startIndex = defaultKeylines.getLastFocalIndex();
            int endIndex = defaultKeylines.getLastNonAnchorIndex();
            int numberOfSteps = endIndex - startIndex;
            if (numberOfSteps <= 0 && defaultKeylines.getLastFocal().getCutoff() > 0.0f) {
                steps.add(this.moveKeylineAndCreateShiftedKeylineList(defaultKeylines, 0, 0, carouselMainAxisSize));
                return steps;
            }
            for (int i = 0; i < numberOfSteps; ++i) {
                KeylineList prevStep = (KeylineList)CollectionsKt.last((List)steps);
                int originalItemIndex = endIndex - i;
                int dstIndex = 0;
                if (originalItemIndex < CollectionsKt.getLastIndex((List)defaultKeylines)) {
                    float originalNeighborAfterSize = defaultKeylines.get(originalItemIndex + 1).getSize();
                    dstIndex = prevStep.lastIndexBeforeFocalRangeWithSize(originalNeighborAfterSize) + 1;
                }
                KeylineList keylines = this.moveKeylineAndCreateShiftedKeylineList(prevStep, defaultKeylines.getLastNonAnchorIndex(), dstIndex, carouselMainAxisSize);
                steps.add(keylines);
            }
            return steps;
        }

        private final KeylineList moveKeylineAndCreateShiftedKeylineList(KeylineList from, int srcIndex, int dstIndex, float carouselMainAxisSize) {
            int pivotDir = srcIndex > dstIndex ? 1 : -1;
            float pivotDelta = (from.get(srcIndex).getSize() - from.get(srcIndex).getCutoff()) * (float)pivotDir;
            int newPivotIndex = from.getPivotIndex() + pivotDir;
            float newPivotOffset = from.getPivot().getOffset() + pivotDelta;
            return KeylineListKt.keylineListOf(carouselMainAxisSize, newPivotIndex, newPivotOffset, (Function1<? super KeylineListScope, Unit>)((Function1)new Function1<KeylineListScope, Unit>(from, srcIndex, dstIndex){
                final /* synthetic */ KeylineList $from;
                final /* synthetic */ int $srcIndex;
                final /* synthetic */ int $dstIndex;
                {
                    this.$from = $from;
                    this.$srcIndex = $srcIndex;
                    this.$dstIndex = $dstIndex;
                    super(1);
                }

                public final void invoke(@NotNull KeylineListScope $this$keylineListOf) {
                    List $this$fastForEach$iv = androidx.compose.material3.carousel.Strategy$Companion.access$move(Strategy.Companion, CollectionsKt.toMutableList((Collection)this.$from), this.$srcIndex, this.$dstIndex);
                    boolean $i$f$fastForEach = false;
                    int n = $this$fastForEach$iv.size();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        E item$iv = $this$fastForEach$iv.get(index$iv);
                        Keyline k = (Keyline)item$iv;
                        boolean bl = false;
                        $this$keylineListOf.add(k.getSize(), k.isAnchor());
                    }
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        private final FloatList getStepInterpolationPoints(float totalShiftDistance, List<KeylineList> steps, boolean isShiftingLeft) {
            void $this$mapTo$iv$iv;
            MutableFloatList points = FloatListKt.mutableFloatListOf((float)0.0f);
            if (totalShiftDistance == 0.0f) {
                return (FloatList)points;
            }
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)1, (int)steps.size());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KeylineList prevKeylines = steps.get((int)(i - true));
                KeylineList currKeylines = steps.get((int)i);
                float distanceShifted = isShiftingLeft ? ((Keyline)CollectionsKt.first((List)currKeylines)).getUnadjustedOffset() - ((Keyline)CollectionsKt.first((List)prevKeylines)).getUnadjustedOffset() : ((Keyline)CollectionsKt.last((List)prevKeylines)).getUnadjustedOffset() - ((Keyline)CollectionsKt.last((List)currKeylines)).getUnadjustedOffset();
                float stepPercentage = distanceShifted / totalShiftDistance;
                float point = i == CollectionsKt.getLastIndex(steps) ? 1.0f : points.get((int)(i - true)) + stepPercentage;
                collection.add(points.add(point));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            return (FloatList)points;
        }

        private final ShiftPointRange getShiftPointRange(int stepsCount, FloatList shiftPoint, float interpolation) {
            float lowerBounds = 0.0f;
            lowerBounds = shiftPoint.get(0);
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)stepsCount);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                float upperBounds = shiftPoint.get(i);
                if (interpolation <= upperBounds) {
                    return new ShiftPointRange(i - 1, i, StrategyKt.access$lerp(0.0f, 1.0f, lowerBounds, upperBounds, interpolation));
                }
                lowerBounds = upperBounds;
            }
            return new ShiftPointRange(0, 0, 0.0f);
        }

        private final List<Keyline> move(List<Keyline> $this$move, int srcIndex, int dstIndex) {
            Keyline keyline = $this$move.get(srcIndex);
            $this$move.remove(srcIndex);
            $this$move.add(dstIndex, keyline);
            return $this$move;
        }

        public static final /* synthetic */ List access$move(Companion $this, List $receiver, int srcIndex, int dstIndex) {
            return $this.move($receiver, srcIndex, dstIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Landroidx/compose/material3/carousel/Strategy$Companion$ShiftPointRange;", "", "fromStepIndex", "", "toStepIndex", "steppedInterpolation", "", "(IIF)V", "getFromStepIndex", "()I", "getSteppedInterpolation", "()F", "getToStepIndex", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "material3_release"})
        private static final class ShiftPointRange {
            private final int fromStepIndex;
            private final int toStepIndex;
            private final float steppedInterpolation;

            public ShiftPointRange(int fromStepIndex, int toStepIndex, float steppedInterpolation) {
                this.fromStepIndex = fromStepIndex;
                this.toStepIndex = toStepIndex;
                this.steppedInterpolation = steppedInterpolation;
            }

            public final int getFromStepIndex() {
                return this.fromStepIndex;
            }

            public final int getToStepIndex() {
                return this.toStepIndex;
            }

            public final float getSteppedInterpolation() {
                return this.steppedInterpolation;
            }

            public final int component1() {
                return this.fromStepIndex;
            }

            public final int component2() {
                return this.toStepIndex;
            }

            public final float component3() {
                return this.steppedInterpolation;
            }

            @NotNull
            public final ShiftPointRange copy(int fromStepIndex, int toStepIndex, float steppedInterpolation) {
                return new ShiftPointRange(fromStepIndex, toStepIndex, steppedInterpolation);
            }

            public static /* synthetic */ ShiftPointRange copy$default(ShiftPointRange shiftPointRange, int n, int n2, float f, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = shiftPointRange.fromStepIndex;
                }
                if ((n3 & 2) != 0) {
                    n2 = shiftPointRange.toStepIndex;
                }
                if ((n3 & 4) != 0) {
                    f = shiftPointRange.steppedInterpolation;
                }
                return shiftPointRange.copy(n, n2, f);
            }

            @NotNull
            public String toString() {
                return "ShiftPointRange(fromStepIndex=" + this.fromStepIndex + ", toStepIndex=" + this.toStepIndex + ", steppedInterpolation=" + this.steppedInterpolation + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.fromStepIndex);
                result = result * 31 + Integer.hashCode(this.toStepIndex);
                result = result * 31 + Float.hashCode(this.steppedInterpolation);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ShiftPointRange)) {
                    return false;
                }
                ShiftPointRange shiftPointRange = (ShiftPointRange)other;
                if (this.fromStepIndex != shiftPointRange.fromStepIndex) {
                    return false;
                }
                if (this.toStepIndex != shiftPointRange.toStepIndex) {
                    return false;
                }
                return Float.compare(this.steppedInterpolation, shiftPointRange.steppedInterpolation) == 0;
            }
        }
    }
}

