/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.material3.carousel.CarouselPageSize;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.Strategy;
import kotlin.Metadata;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0000\u00a8\u0006\n"}, d2={"KeylineSnapPosition", "Landroidx/compose/foundation/gestures/snapping/SnapPosition;", "pageSize", "Landroidx/compose/material3/carousel/CarouselPageSize;", "getSnapPositionOffset", "", "strategy", "Landroidx/compose/material3/carousel/Strategy;", "itemIndex", "itemCount", "material3_release"})
public final class KeylineSnapPositionKt {
    public static final int getSnapPositionOffset(@NotNull Strategy strategy, int itemIndex, int itemCount) {
        if (!strategy.isValid()) {
            return 0;
        }
        int numOfFocalKeylines = strategy.getDefaultKeylines().getLastFocalIndex() - strategy.getDefaultKeylines().getFirstFocalIndex();
        int startStepsSize = strategy.getStartKeylineSteps().size() + numOfFocalKeylines;
        int endStepsSize = strategy.getEndKeylineSteps().size() + numOfFocalKeylines;
        int offset2 = MathKt.roundToInt((float)(strategy.getDefaultKeylines().getFirstFocal().getUnadjustedOffset() - strategy.getItemMainAxisSize() / 2.0f));
        if (itemIndex < startStepsSize) {
            int startIndex = Math.max(0, startStepsSize - 1 - itemIndex);
            startIndex = Math.min(strategy.getStartKeylineSteps().size() - 1, startIndex);
            KeylineList startKeylines = strategy.getStartKeylineSteps().get(startIndex);
            offset2 = MathKt.roundToInt((float)(startKeylines.getFirstFocal().getUnadjustedOffset() - strategy.getItemMainAxisSize() / 2.0f));
        }
        if (itemCount > numOfFocalKeylines + 1 && itemIndex >= itemCount - endStepsSize) {
            int endIndex = Math.max(0, itemIndex - itemCount + endStepsSize);
            endIndex = Math.min(strategy.getEndKeylineSteps().size() - 1, endIndex);
            KeylineList endKeylines = strategy.getEndKeylineSteps().get(endIndex);
            offset2 = MathKt.roundToInt((float)(endKeylines.getFirstFocal().getUnadjustedOffset() - strategy.getItemMainAxisSize() / 2.0f));
        }
        return offset2;
    }

    @NotNull
    public static final SnapPosition KeylineSnapPosition(@NotNull CarouselPageSize pageSize) {
        return new SnapPosition(pageSize){
            final /* synthetic */ CarouselPageSize $pageSize;
            {
                this.$pageSize = $pageSize;
            }

            public int position(int layoutSize, int itemSize, int beforeContentPadding, int afterContentPadding, int itemIndex, int itemCount) {
                return KeylineSnapPositionKt.getSnapPositionOffset(this.$pageSize.getStrategy(), itemIndex, itemCount);
            }
        };
    }
}

