/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal.colorUtil;

import androidx.annotation.Nullable;
import androidx.compose.material3.internal.colorUtil.CamUtils;
import androidx.compose.material3.internal.colorUtil.Frame;
import androidx.compose.material3.internal.colorUtil.HctSolver;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.graphics.ColorUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001aR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\r\u00a8\u0006\u001f"}, d2={"Landroidx/compose/material3/internal/colorUtil/Cam;", "", "hue", "", "chroma", "j", "m", "s", "jstar", "astar", "bstar", "(FFFFFFFF)V", "getAstar", "()F", "getBstar", "getChroma", "getHue", "getJ", "getJstar", "setJstar", "(F)V", "getM", "getS", "distance", "other", "viewed", "", "frame", "Landroidx/compose/material3/internal/colorUtil/Frame;", "viewedInSrgb", "Companion", "material3_release"})
@StabilityInferred(parameters=0)
public final class Cam {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float hue;
    private final float chroma;
    private final float j;
    private final float m;
    private final float s;
    private float jstar;
    private final float astar;
    private final float bstar;
    public static final int $stable = 8;
    private static final float DL_MAX = 0.2f;
    private static final float DE_MAX = 1.0f;
    private static final float CHROMA_SEARCH_ENDPOINT = 0.4f;
    private static final float LIGHTNESS_SEARCH_ENDPOINT = 0.01f;

    public Cam(float hue, float chroma, float j, float m, float s, float jstar, float astar, float bstar) {
        this.hue = hue;
        this.chroma = chroma;
        this.j = j;
        this.m = m;
        this.s = s;
        this.jstar = jstar;
        this.astar = astar;
        this.bstar = bstar;
    }

    public final float getHue() {
        return this.hue;
    }

    public final float getChroma() {
        return this.chroma;
    }

    public final float getJ() {
        return this.j;
    }

    public final float getM() {
        return this.m;
    }

    public final float getS() {
        return this.s;
    }

    public final float getJstar() {
        return this.jstar;
    }

    public final void setJstar(float f) {
        this.jstar = f;
    }

    public final float getAstar() {
        return this.astar;
    }

    public final float getBstar() {
        return this.bstar;
    }

    public final float distance(@NotNull Cam other) {
        float dJ = this.jstar - other.jstar;
        float dA = this.astar - other.astar;
        float dB = this.bstar - other.bstar;
        double dEPrime = Math.sqrt(dJ * dJ + dA * dA + dB * dB);
        double dE = 1.41 * Math.pow(dEPrime, 0.63);
        return (float)dE;
    }

    public final int viewedInSrgb() {
        return this.viewed(Frame.Companion.getDefault());
    }

    public final int viewed(@NotNull Frame frame) {
        float alpha2 = this.chroma == 0.0f || this.j == 0.0f ? 0.0f : this.chroma / (float)Math.sqrt(this.j / 100.0f);
        float t = alpha2 / (float)Math.pow(1.64f - (float)Math.pow((float)Math.pow(0.29f, frame.getN()), 0.73f), 1.1111112f);
        float hRad = this.hue * (float)Math.PI / 180.0f;
        float eHue = 0.25f * ((float)Math.cos(hRad + 2.0f) + 3.8f);
        float ac = frame.getAw() * (float)Math.pow(this.j / 100.0f, 1.0f / frame.getC() / frame.getZ());
        float p1 = eHue * 3846.1538f * frame.getNc() * frame.getNcb();
        float p2 = ac / frame.getNbb();
        float hSin = (float)Math.sin(hRad);
        float hCos = (float)Math.cos(hRad);
        float gamma = 23.0f * (p2 + 0.305f) * t / (23.0f * p1 + 11.0f * t * hCos + 108.0f * t * hSin);
        float a = gamma * hCos;
        float b = gamma * hSin;
        float rA = (460.0f * p2 + 451.0f * a + 288.0f * b) / 1403.0f;
        float gA = (460.0f * p2 - 891.0f * a - 261.0f * b) / 1403.0f;
        float bA = (460.0f * p2 - 220.0f * a - 6300.0f * b) / 1403.0f;
        float rCBase = Math.max(0.0f, 27.13f * Math.abs(rA) / (400.0f - Math.abs(rA)));
        float rC = Math.signum(rA) * (100.0f / frame.getFl()) * (float)Math.pow(rCBase, 2.3809524f);
        float gCBase = Math.max(0.0f, 27.13f * Math.abs(gA) / (400.0f - Math.abs(gA)));
        float gC = Math.signum(gA) * (100.0f / frame.getFl()) * (float)Math.pow(gCBase, 2.3809524f);
        float bCBase = Math.max(0.0f, 27.13f * Math.abs(bA) / (400.0f - Math.abs(bA)));
        float bC = Math.signum(bA) * (100.0f / frame.getFl()) * (float)Math.pow(bCBase, 2.3809524f);
        float rF = rC / frame.getRgbD()[0];
        float gF = gC / frame.getRgbD()[1];
        float bF = bC / frame.getRgbD()[2];
        float[][] matrix = CamUtils.INSTANCE.getCAM16RGB_TO_XYZ();
        float x = rF * matrix[0][0] + gF * matrix[0][1] + bF * matrix[0][2];
        float y = rF * matrix[1][0] + gF * matrix[1][1] + bF * matrix[1][2];
        float z = rF * matrix[2][0] + gF * matrix[2][1] + bF * matrix[2][2];
        int argb = ColorUtils.XYZToColor((double)x, (double)y, (double)z);
        return argb;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0003J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J(\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J(\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Landroidx/compose/material3/internal/colorUtil/Cam$Companion;", "", "()V", "CHROMA_SEARCH_ENDPOINT", "", "DE_MAX", "DL_MAX", "LIGHTNESS_SEARCH_ENDPOINT", "findCamByJ", "Landroidx/compose/material3/internal/colorUtil/Cam;", "hue", "chroma", "lstar", "fromInt", "argb", "", "fromIntInFrame", "frame", "Landroidx/compose/material3/internal/colorUtil/Frame;", "fromJch", "j", "c", "h", "fromJchInFrame", "getInt", "material3_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getInt(float hue, float chroma, float lstar) {
            return this.getInt(hue, chroma, lstar, Frame.Companion.getDefault());
        }

        @NotNull
        public final Cam fromInt(int argb) {
            return this.fromIntInFrame(argb, Frame.Companion.getDefault());
        }

        private final Cam fromIntInFrame(int argb, Frame frame) {
            float[] xyz = CamUtils.INSTANCE.xyzFromInt(argb);
            float[][] matrix = CamUtils.INSTANCE.getXYZ_TO_CAM16RGB();
            float rT = xyz[0] * matrix[0][0] + xyz[1] * matrix[0][1] + xyz[2] * matrix[0][2];
            float gT = xyz[0] * matrix[1][0] + xyz[1] * matrix[1][1] + xyz[2] * matrix[1][2];
            float bT = xyz[0] * matrix[2][0] + xyz[1] * matrix[2][1] + xyz[2] * matrix[2][2];
            float rD = frame.getRgbD()[0] * rT;
            float gD = frame.getRgbD()[1] * gT;
            float bD = frame.getRgbD()[2] * bT;
            float rAF = (float)Math.pow(frame.getFl() * Math.abs(rD) / 100.0f, 0.42f);
            float gAF = (float)Math.pow(frame.getFl() * Math.abs(gD) / 100.0f, 0.42f);
            float bAF = (float)Math.pow(frame.getFl() * Math.abs(bD) / 100.0f, 0.42f);
            float rA = Math.signum(rD) * 400.0f * rAF / (rAF + 27.13f);
            float gA = Math.signum(gD) * 400.0f * gAF / (gAF + 27.13f);
            float bA = Math.signum(bD) * 400.0f * bAF / (bAF + 27.13f);
            float a = (11.0f * rA + -12.0f * gA + bA) / 11.0f;
            float b = (rA + gA - 2.0f * bA) / 9.0f;
            float u = (20.0f * rA + 20.0f * gA + 21.0f * bA) / 20.0f;
            float p2 = (40.0f * rA + 20.0f * gA + bA) / 20.0f;
            float atan2 = (float)Math.atan2(b, a);
            float atanDegrees = atan2 * 180.0f / (float)Math.PI;
            float hue = atanDegrees < 0.0f ? atanDegrees + 360.0f : (atanDegrees >= 360.0f ? atanDegrees - 360.0f : atanDegrees);
            float hueRadians = hue * (float)Math.PI / 180.0f;
            float ac = p2 * frame.getNbb();
            float j = 100.0f * (float)Math.pow(ac / frame.getAw(), frame.getC() * frame.getZ());
            float huePrime = (double)hue < 20.14 ? hue + (float)360 : hue;
            float eHue = 0.25f * ((float)Math.cos(huePrime * (float)Math.PI / 180.0f + 2.0f) + 3.8f);
            float p1 = 3846.1538f * eHue * frame.getNc() * frame.getNcb();
            float t = p1 * (float)Math.sqrt(a * a + b * b) / (u + 0.305f);
            float alpha2 = (float)Math.pow(t, 0.9f) * (float)Math.pow(1.64f - (float)Math.pow(0.29f, frame.getN()), 0.73f);
            float c = alpha2 * (float)Math.sqrt(j / 100.0f);
            float m = c * frame.getFlRoot();
            float s = 50.0f * (float)Math.sqrt(alpha2 * frame.getC() / (frame.getAw() + 4.0f));
            float jstar = 1.7f * j / (1.0f + 0.007f * j);
            float mstar = 43.85965f * (float)Math.log(1.0f + 0.0228f * m);
            float astar = mstar * (float)Math.cos(hueRadians);
            float bstar = mstar * (float)Math.sin(hueRadians);
            return new Cam(hue, c, j, m, s, jstar, astar, bstar);
        }

        private final Cam fromJch(float j, float c, float h) {
            return this.fromJchInFrame(j, c, h, Frame.Companion.getDefault());
        }

        private final Cam fromJchInFrame(float j, float c, float h, Frame frame) {
            float m = c * frame.getFlRoot();
            float alpha2 = c / (float)Math.sqrt((double)j / 100.0);
            float s = 50.0f * (float)Math.sqrt(alpha2 * frame.getC() / (frame.getAw() + 4.0f));
            float hueRadians = h * (float)Math.PI / 180.0f;
            float jstar = 1.7f * j / (1.0f + 0.007f * j);
            float mstar = 43.85965f * (float)Math.log(1.0 + 0.0228 * (double)m);
            float astar = mstar * (float)Math.cos(hueRadians);
            float bstar = mstar * (float)Math.sin(hueRadians);
            return new Cam(h, c, j, m, s, jstar, astar, bstar);
        }

        private final int getInt(float hue, float chroma, float lstar, Frame frame) {
            float huePrime = hue;
            if (Intrinsics.areEqual((Object)frame, (Object)Frame.Companion.getDefault())) {
                return HctSolver.INSTANCE.solveToInt(huePrime, chroma, lstar);
            }
            if ((double)chroma < 1.0 || (double)Math.round(lstar) <= 0.0 || (double)Math.round(lstar) >= 100.0) {
                return CamUtils.INSTANCE.intFromLstar(lstar);
            }
            huePrime = huePrime < 0.0f ? 0.0f : Math.min(360.0f, huePrime);
            float high = chroma;
            float mid = chroma;
            float low = 0.0f;
            boolean isFirstLoop = true;
            Cam answer = null;
            while (Math.abs((double)(low - high)) >= (double)0.4f) {
                Cam possibleAnswer = this.findCamByJ(huePrime, mid, lstar);
                if (isFirstLoop) {
                    if (possibleAnswer != null) {
                        return possibleAnswer.viewed(frame);
                    }
                    isFirstLoop = false;
                    mid = low + (high - low) / 2.0f;
                    continue;
                }
                if (possibleAnswer == null) {
                    high = mid;
                } else {
                    answer = possibleAnswer;
                    low = mid;
                }
                mid = low + (high - low) / 2.0f;
            }
            if (answer == null) {
                return CamUtils.INSTANCE.intFromLstar(lstar);
            }
            return answer.viewed(frame);
        }

        @Nullable
        private final Cam findCamByJ(float hue, float chroma, float lstar) {
            float low = 0.0f;
            float high = 100.0f;
            float mid = 0.0f;
            float bestdL = 1000.0f;
            float bestdE = 1000.0f;
            Cam bestCam = null;
            while (Math.abs((double)(low - high)) > (double)0.01f) {
                Cam camClipped;
                float dE;
                mid = low + (high - low) / (float)2;
                Cam camBeforeClip = this.fromJch(mid, chroma, hue);
                int clipped = camBeforeClip.viewedInSrgb();
                float clippedLstar = CamUtils.INSTANCE.lstarFromInt(clipped);
                float dL = (float)Math.abs((double)(lstar - clippedLstar));
                if (dL < 0.2f && (dE = (camClipped = this.fromInt(clipped)).distance(this.fromJch(camClipped.getJ(), camClipped.getChroma(), hue))) <= 1.0f) {
                    bestdL = dL;
                    bestdE = dE;
                    bestCam = camClipped;
                }
                if (bestdL == 0.0f && bestdE == 0.0f) break;
                if (clippedLstar < lstar) {
                    low = mid;
                    continue;
                }
                high = mid;
            }
            return bestCam;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

