/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.carousel;

import androidx.collection.FloatList;
import androidx.collection.FloatListKt;
import androidx.collection.MutableFloatList;
import androidx.compose.material3.carousel.Keyline;
import androidx.compose.material3.carousel.KeylineList;
import androidx.compose.material3.carousel.KeylineListKt;
import androidx.compose.material3.carousel.KeylineListScope;
import androidx.compose.material3.carousel.ShiftPointRange;
import androidx.compose.ui.util.MathHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010!\n\u0000\u001a8\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u001a \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002\u001a.\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u0019\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u001a&\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u001a0\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002\u001a0\u0010&\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a(\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0**\b\u0012\u0004\u0012\u00020\b0*2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nH\u0002\u00a8\u0006+"}, d2={"createShiftedKeylineListForContentPadding", "Landroidx/compose/material3/carousel/KeylineList;", "from", "carouselMainAxisSize", "", "itemSpacing", "contentPadding", "pivot", "Landroidx/compose/material3/carousel/Keyline;", "pivotIndex", "", "getEndKeylineSteps", "", "defaultKeylines", "afterContentPadding", "getEndShiftDistance", "endKeylineSteps", "getShiftPointRange", "Landroidx/compose/material3/carousel/ShiftPointRange;", "stepsCount", "shiftPoint", "Landroidx/collection/FloatList;", "interpolation", "getStartKeylineSteps", "beforeContentPadding", "getStartShiftDistance", "startKeylineSteps", "getStepInterpolationPoints", "totalShiftDistance", "steps", "isShiftingLeft", "", "lerp", "outputMin", "outputMax", "inputMin", "inputMax", "value", "moveKeylineAndCreateShiftedKeylineList", "srcIndex", "dstIndex", "move", "", "material3_release"})
@SourceDebugExtension(value={"SMAP\nStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/StrategyKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,626:1\n235#2,3:627\n33#2,4:630\n238#2,2:634\n38#2:636\n240#2:637\n277#2,3:638\n69#2,4:641\n280#2,2:645\n74#2:647\n282#2:648\n1549#3:649\n1620#3,3:650\n1855#3,2:653\n*S KotlinDebug\n*F\n+ 1 Strategy.kt\nandroidx/compose/material3/carousel/StrategyKt\n*L\n483#1:627,3\n483#1:630,4\n483#1:634,2\n483#1:636\n483#1:637\n501#1:638,3\n501#1:641,4\n501#1:645,2\n501#1:647\n501#1:648\n562#1:649\n562#1:650,3\n590#1:653,2\n*E\n"})
public final class StrategyKt {
    private static final float getStartShiftDistance(List<KeylineList> startKeylineSteps, float beforeContentPadding) {
        if (startKeylineSteps.isEmpty()) {
            return 0.0f;
        }
        return Math.max(((Keyline)CollectionsKt.first((List)((List)CollectionsKt.last(startKeylineSteps)))).getUnadjustedOffset() - ((Keyline)CollectionsKt.first((List)((List)CollectionsKt.first(startKeylineSteps)))).getUnadjustedOffset(), beforeContentPadding);
    }

    private static final float getEndShiftDistance(List<KeylineList> endKeylineSteps, float afterContentPadding) {
        if (endKeylineSteps.isEmpty()) {
            return 0.0f;
        }
        return Math.max(((Keyline)CollectionsKt.last((List)((List)CollectionsKt.first(endKeylineSteps)))).getUnadjustedOffset() - ((Keyline)CollectionsKt.last((List)((List)CollectionsKt.last(endKeylineSteps)))).getUnadjustedOffset(), afterContentPadding);
    }

    private static final List<KeylineList> getStartKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize, float itemSpacing, float beforeContentPadding) {
        if (defaultKeylines.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List steps = new ArrayList();
        steps.add(defaultKeylines);
        if (defaultKeylines.isFirstFocalItemAtStartOfContainer()) {
            if (!(beforeContentPadding == 0.0f)) {
                steps.add(StrategyKt.createShiftedKeylineListForContentPadding(defaultKeylines, carouselMainAxisSize, itemSpacing, beforeContentPadding, defaultKeylines.getFirstFocal(), defaultKeylines.getFirstFocalIndex()));
            }
            return steps;
        }
        int startIndex = defaultKeylines.getFirstNonAnchorIndex();
        int endIndex = defaultKeylines.getFirstFocalIndex();
        int numberOfSteps = endIndex - startIndex;
        if (numberOfSteps <= 0 && defaultKeylines.getFirstFocal().getCutoff() > 0.0f) {
            steps.add(StrategyKt.moveKeylineAndCreateShiftedKeylineList(defaultKeylines, 0, 0, carouselMainAxisSize, itemSpacing));
            return steps;
        }
        for (int i = 0; i < numberOfSteps; ++i) {
            KeylineList prevStep = (KeylineList)CollectionsKt.last((List)steps);
            int originalItemIndex = startIndex + i;
            int dstIndex = CollectionsKt.getLastIndex((List)defaultKeylines);
            if (originalItemIndex > 0) {
                float originalNeighborBeforeSize = defaultKeylines.get(originalItemIndex - 1).getSize();
                dstIndex = prevStep.firstIndexAfterFocalRangeWithSize(originalNeighborBeforeSize) - 1;
            }
            steps.add(StrategyKt.moveKeylineAndCreateShiftedKeylineList(prevStep, defaultKeylines.getFirstNonAnchorIndex(), dstIndex, carouselMainAxisSize, itemSpacing));
        }
        if (!(beforeContentPadding == 0.0f)) {
            steps.set(CollectionsKt.getLastIndex((List)steps), StrategyKt.createShiftedKeylineListForContentPadding((KeylineList)CollectionsKt.last((List)steps), carouselMainAxisSize, itemSpacing, beforeContentPadding, ((KeylineList)CollectionsKt.last((List)steps)).getFirstFocal(), ((KeylineList)CollectionsKt.last((List)steps)).getFirstFocalIndex()));
        }
        return steps;
    }

    private static final List<KeylineList> getEndKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize, float itemSpacing, float afterContentPadding) {
        if (defaultKeylines.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List steps = new ArrayList();
        steps.add(defaultKeylines);
        if (defaultKeylines.isLastFocalItemAtEndOfContainer(carouselMainAxisSize)) {
            if (!(afterContentPadding == 0.0f)) {
                steps.add(StrategyKt.createShiftedKeylineListForContentPadding(defaultKeylines, carouselMainAxisSize, itemSpacing, -afterContentPadding, defaultKeylines.getLastFocal(), defaultKeylines.getLastFocalIndex()));
            }
            return steps;
        }
        int startIndex = defaultKeylines.getLastFocalIndex();
        int endIndex = defaultKeylines.getLastNonAnchorIndex();
        int numberOfSteps = endIndex - startIndex;
        if (numberOfSteps <= 0 && defaultKeylines.getLastFocal().getCutoff() > 0.0f) {
            steps.add(StrategyKt.moveKeylineAndCreateShiftedKeylineList(defaultKeylines, 0, 0, carouselMainAxisSize, itemSpacing));
            return steps;
        }
        for (int i = 0; i < numberOfSteps; ++i) {
            KeylineList prevStep = (KeylineList)CollectionsKt.last((List)steps);
            int originalItemIndex = endIndex - i;
            int dstIndex = 0;
            if (originalItemIndex < CollectionsKt.getLastIndex((List)defaultKeylines)) {
                float originalNeighborAfterSize = defaultKeylines.get(originalItemIndex + 1).getSize();
                dstIndex = prevStep.lastIndexBeforeFocalRangeWithSize(originalNeighborAfterSize) + 1;
            }
            KeylineList keylines = StrategyKt.moveKeylineAndCreateShiftedKeylineList(prevStep, defaultKeylines.getLastNonAnchorIndex(), dstIndex, carouselMainAxisSize, itemSpacing);
            steps.add(keylines);
        }
        if (!(afterContentPadding == 0.0f)) {
            steps.set(CollectionsKt.getLastIndex((List)steps), StrategyKt.createShiftedKeylineListForContentPadding((KeylineList)CollectionsKt.last((List)steps), carouselMainAxisSize, itemSpacing, -afterContentPadding, ((KeylineList)CollectionsKt.last((List)steps)).getLastFocal(), ((KeylineList)CollectionsKt.last((List)steps)).getLastFocalIndex()));
        }
        return steps;
    }

    /*
     * WARNING - void declaration
     */
    private static final KeylineList createShiftedKeylineListForContentPadding(KeylineList from, float carouselMainAxisSize, float itemSpacing, float contentPadding, Keyline pivot, int pivotIndex) {
        Keyline it;
        List $this$fastFilter$iv = from;
        boolean $i$f$fastFilter = false;
        ArrayList target$iv = new ArrayList($this$fastFilter$iv.size());
        List $this$fastForEach$iv$iv = $this$fastFilter$iv;
        boolean $i$f$fastForEach = false;
        int n = $this$fastForEach$iv$iv.size();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            Object item$iv$iv;
            Object it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
            boolean bl = false;
            it = (Keyline)it$iv;
            boolean bl2 = false;
            if (!(!it.isAnchor())) continue;
            ((Collection)target$iv).add(it$iv);
        }
        int numberOfNonAnchorKeylines = ((Collection)target$iv).size();
        float sizeReduction = contentPadding / (float)numberOfNonAnchorKeylines;
        KeylineList newKeylines2 = KeylineListKt.keylineListOf(carouselMainAxisSize, itemSpacing, pivotIndex, pivot.getOffset() - sizeReduction / 2.0f + contentPadding, (Function1<? super KeylineListScope, Unit>)((Function1)new Function1<KeylineListScope, Unit>(from, sizeReduction){
            final /* synthetic */ KeylineList $from;
            final /* synthetic */ float $sizeReduction;
            {
                this.$from = $from;
                this.$sizeReduction = $sizeReduction;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(KeylineListScope $this$keylineListOf) {
                void $this$fastForEach$iv;
                List list = this.$from;
                float f = this.$sizeReduction;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    E item$iv = $this$fastForEach$iv.get(index$iv);
                    Keyline k = (Keyline)item$iv;
                    boolean bl = false;
                    $this$keylineListOf.add(k.getSize() - Math.abs(f), k.isAnchor());
                }
            }
        }));
        List $this$fastMapIndexed$iv = newKeylines2;
        boolean $i$f$fastMapIndexed = false;
        ArrayList target$iv2 = new ArrayList($this$fastMapIndexed$iv.size());
        List $this$fastForEachIndexed$iv$iv = $this$fastMapIndexed$iv;
        boolean $i$f$fastForEachIndexed = false;
        int index$iv$iv = 0;
        int n2 = $this$fastForEachIndexed$iv$iv.size();
        while (index$iv$iv < n2) {
            void i;
            void k;
            void e$iv;
            Object item$iv$iv = $this$fastForEachIndexed$iv$iv.get(index$iv$iv);
            it = item$iv$iv;
            int index$iv = index$iv$iv++;
            boolean bl = false;
            Keyline keyline = (Keyline)e$iv;
            int n3 = index$iv;
            Collection collection = target$iv2;
            boolean bl3 = false;
            collection.add(Keyline.copy$default((Keyline)k, 0.0f, 0.0f, from.get((int)i).getUnadjustedOffset(), false, false, false, 0.0f, 123, null));
        }
        List list = target$iv2;
        return new KeylineList(list);
    }

    private static final KeylineList moveKeylineAndCreateShiftedKeylineList(KeylineList from, int srcIndex, int dstIndex, float carouselMainAxisSize, float itemSpacing) {
        int pivotDir = srcIndex > dstIndex ? 1 : -1;
        float pivotDelta = (from.get(srcIndex).getSize() - from.get(srcIndex).getCutoff() + itemSpacing) * (float)pivotDir;
        int newPivotIndex = from.getPivotIndex() + pivotDir;
        float newPivotOffset = from.getPivot().getOffset() + pivotDelta;
        return KeylineListKt.keylineListOf(carouselMainAxisSize, itemSpacing, newPivotIndex, newPivotOffset, (Function1<? super KeylineListScope, Unit>)((Function1)new Function1<KeylineListScope, Unit>(from, srcIndex, dstIndex){
            final /* synthetic */ KeylineList $from;
            final /* synthetic */ int $srcIndex;
            final /* synthetic */ int $dstIndex;
            {
                this.$from = $from;
                this.$srcIndex = $srcIndex;
                this.$dstIndex = $dstIndex;
                super(1);
            }

            public final void invoke(KeylineListScope $this$keylineListOf) {
                List $this$fastForEach$iv = StrategyKt.access$move(CollectionsKt.toMutableList((Collection)this.$from), this.$srcIndex, this.$dstIndex);
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    E item$iv = $this$fastForEach$iv.get(index$iv);
                    Keyline k = (Keyline)item$iv;
                    boolean bl = false;
                    $this$keylineListOf.add(k.getSize(), k.isAnchor());
                }
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private static final FloatList getStepInterpolationPoints(float totalShiftDistance, List<KeylineList> steps, boolean isShiftingLeft) {
        void $this$mapTo$iv$iv;
        MutableFloatList points = FloatListKt.mutableFloatListOf((float)0.0f);
        if (totalShiftDistance == 0.0f || steps.isEmpty()) {
            return (FloatList)points;
        }
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)1, (int)steps.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KeylineList prevKeylines = steps.get((int)(i - true));
            KeylineList currKeylines = steps.get((int)i);
            float distanceShifted = isShiftingLeft ? ((Keyline)CollectionsKt.first((List)currKeylines)).getUnadjustedOffset() - ((Keyline)CollectionsKt.first((List)prevKeylines)).getUnadjustedOffset() : ((Keyline)CollectionsKt.last((List)prevKeylines)).getUnadjustedOffset() - ((Keyline)CollectionsKt.last((List)currKeylines)).getUnadjustedOffset();
            float stepPercentage = distanceShifted / totalShiftDistance;
            float point = i == CollectionsKt.getLastIndex(steps) ? 1.0f : points.get((int)(i - true)) + stepPercentage;
            collection.add(points.add(point));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        return (FloatList)points;
    }

    private static final ShiftPointRange getShiftPointRange(int stepsCount, FloatList shiftPoint, float interpolation) {
        float lowerBounds = 0.0f;
        lowerBounds = shiftPoint.get(0);
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)1, (int)stepsCount);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            float upperBounds = shiftPoint.get(i);
            if (interpolation <= upperBounds) {
                return new ShiftPointRange(i - 1, i, StrategyKt.lerp(0.0f, 1.0f, lowerBounds, upperBounds, interpolation));
            }
            lowerBounds = upperBounds;
        }
        return new ShiftPointRange(0, 0, 0.0f);
    }

    private static final List<Keyline> move(List<Keyline> $this$move, int srcIndex, int dstIndex) {
        Keyline keyline = $this$move.get(srcIndex);
        $this$move.remove(srcIndex);
        $this$move.add(dstIndex, keyline);
        return $this$move;
    }

    private static final float lerp(float outputMin, float outputMax, float inputMin, float inputMax, float value) {
        if (value <= inputMin) {
            return outputMin;
        }
        if (value >= inputMax) {
            return outputMax;
        }
        return MathHelpersKt.lerp((float)outputMin, (float)outputMax, (float)((value - inputMin) / (inputMax - inputMin)));
    }

    public static final /* synthetic */ float access$getStartShiftDistance(List startKeylineSteps, float beforeContentPadding) {
        return StrategyKt.getStartShiftDistance(startKeylineSteps, beforeContentPadding);
    }

    public static final /* synthetic */ float access$getEndShiftDistance(List endKeylineSteps, float afterContentPadding) {
        return StrategyKt.getEndShiftDistance(endKeylineSteps, afterContentPadding);
    }

    public static final /* synthetic */ FloatList access$getStepInterpolationPoints(float totalShiftDistance, List steps, boolean isShiftingLeft) {
        return StrategyKt.getStepInterpolationPoints(totalShiftDistance, steps, isShiftingLeft);
    }

    public static final /* synthetic */ List access$getStartKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize, float itemSpacing, float beforeContentPadding) {
        return StrategyKt.getStartKeylineSteps(defaultKeylines, carouselMainAxisSize, itemSpacing, beforeContentPadding);
    }

    public static final /* synthetic */ List access$getEndKeylineSteps(KeylineList defaultKeylines, float carouselMainAxisSize, float itemSpacing, float afterContentPadding) {
        return StrategyKt.getEndKeylineSteps(defaultKeylines, carouselMainAxisSize, itemSpacing, afterContentPadding);
    }

    public static final /* synthetic */ float access$lerp(float outputMin, float outputMax, float inputMin, float inputMax, float value) {
        return StrategyKt.lerp(outputMin, outputMax, inputMin, inputMax, value);
    }

    public static final /* synthetic */ ShiftPointRange access$getShiftPointRange(int stepsCount, FloatList shiftPoint, float interpolation) {
        return StrategyKt.getShiftPointRange(stepsCount, shiftPoint, interpolation);
    }

    public static final /* synthetic */ List access$move(List $receiver, int srcIndex, int dstIndex) {
        return StrategyKt.move($receiver, srcIndex, dstIndex);
    }
}

