/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal;

import android.icu.text.DateFormat;
import android.icu.text.DisplayContext;
import android.icu.util.TimeZone;
import android.os.Build;
import androidx.compose.material3.internal.CalendarModel;
import androidx.compose.material3.internal.CalendarModelImpl;
import androidx.compose.material3.internal.DateInputFormat;
import androidx.compose.material3.internal.LegacyCalendarModelImpl;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a8\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a8\u0006\u0010"}, d2={"createCalendarModel", "Landroidx/compose/material3/internal/CalendarModel;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "datePatternAsInputFormat", "Landroidx/compose/material3/internal/DateInputFormat;", "localeFormat", "", "formatWithSkeleton", "utcTimeMillis", "", "skeleton", "cache", "", "", "material3_release"})
@SourceDebugExtension(value={"SMAP\nCalendarModel.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CalendarModel.android.kt\nandroidx/compose/material3/internal/CalendarModel_androidKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,116:1\n372#2,7:117\n372#2,7:124\n*S KotlinDebug\n*F\n+ 1 CalendarModel.android.kt\nandroidx/compose/material3/internal/CalendarModel_androidKt\n*L\n58#1:117,7\n74#1:124,7\n*E\n"})
public final class CalendarModel_androidKt {
    @NotNull
    public static final CalendarModel createCalendarModel(@NotNull Locale locale) {
        return Build.VERSION.SDK_INT >= 26 ? (CalendarModel)new CalendarModelImpl(locale) : (CalendarModel)new LegacyCalendarModelImpl(locale);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String formatWithSkeleton(long utcTimeMillis, @NotNull String skeleton, @NotNull Locale locale, @NotNull Map<String, Object> cache) {
        Object v;
        void $this$getOrPut$iv;
        if (Build.VERSION.SDK_INT >= 24) {
            Object object;
            void $this$getOrPut$iv2;
            Map<String, Object> map2 = cache;
            String key$iv = "S:" + skeleton + locale.toLanguageTag();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv2.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                DateFormat instanceForSkeleton = DateFormat.getInstanceForSkeleton((String)skeleton, (Locale)locale);
                instanceForSkeleton.setContext(DisplayContext.CAPITALIZATION_FOR_STANDALONE);
                instanceForSkeleton.setTimeZone(TimeZone.GMT_ZONE);
                DateFormat answer$iv = instanceForSkeleton;
                $this$getOrPut$iv2.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Intrinsics.checkNotNull(object, (String)"null cannot be cast to non-null type android.icu.text.DateFormat");
            DateFormat instanceForSkeleton = (DateFormat)object;
            return instanceForSkeleton.format(new Date(utcTimeMillis));
        }
        Map<String, Object> map3 = cache;
        String key$iv = "S:" + skeleton + locale.toLanguageTag();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            String answer$iv = android.text.format.DateFormat.getBestDateTimePattern((Locale)locale, (String)skeleton);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            v = answer$iv;
        } else {
            v = value$iv;
        }
        String pattern = v.toString();
        return LegacyCalendarModelImpl.Companion.formatWithPattern(utcTimeMillis, pattern, locale, cache);
    }

    @NotNull
    public static final DateInputFormat datePatternAsInputFormat(@NotNull String localeFormat) {
        MatchResult delimiterMatchResult;
        CharSequence charSequence = localeFormat;
        Regex regex = new Regex("[^dMy/\\-.]");
        String string2 = "";
        charSequence = regex.replace(charSequence, string2);
        regex = new Regex("d{1,2}");
        string2 = "dd";
        charSequence = regex.replace(charSequence, string2);
        regex = new Regex("M{1,2}");
        string2 = "MM";
        charSequence = regex.replace(charSequence, string2);
        regex = new Regex("y{1,4}");
        string2 = "yyyy";
        String patternWithDelimiters = StringsKt.removeSuffix((String)StringsKt.replace$default((String)regex.replace(charSequence, string2), (String)"My", (String)"M/y", (boolean)false, (int)4, null), (CharSequence)".");
        Regex delimiterRegex = new Regex("[/\\-.]");
        MatchResult matchResult = delimiterMatchResult = Regex.find$default((Regex)delimiterRegex, (CharSequence)patternWithDelimiters, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        MatchGroup matchGroup = matchResult.getGroups().get(0);
        Intrinsics.checkNotNull((Object)matchGroup);
        int delimiterIndex = matchGroup.getRange().getFirst();
        String string3 = patternWithDelimiters.substring(delimiterIndex, delimiterIndex + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String delimiter = string3;
        return new DateInputFormat(patternWithDelimiters, delimiter.charAt(0));
    }
}

