/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3.internal.colorUtil;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.graphics.ColorUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0013\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u0007\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0015J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0015H\u0002J \u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013H\u0002J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0015H\u0002J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020)J\u0010\u0010*\u001a\u00020)2\u0006\u0010'\u001a\u00020\u0013H\u0002J\u000e\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u0013J\u0010\u0010-\u001a\u00020)2\u0006\u0010 \u001a\u00020)H\u0002J\u000e\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0015J\u000e\u00100\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u0013J\u0010\u00101\u001a\u00020)2\u0006\u0010,\u001a\u00020\u0013H\u0002J\u000e\u00102\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0010\u0010\u0007R\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u00063"}, d2={"Landroidx/compose/material3/internal/colorUtil/CamUtils;", "", "()V", "CAM16RGB_TO_XYZ", "", "", "getCAM16RGB_TO_XYZ", "()[[F", "[[F", "SRGB_TO_XYZ", "", "[[D", "WHITE_POINT_D65", "getWHITE_POINT_D65", "()[F", "XYZ_TO_CAM16RGB", "getXYZ_TO_CAM16RGB", "XYZ_TO_SRGB", "argbFromLinrgbComponents", "", "r", "", "g", "b", "argbFromLstar", "lstar", "argbFromRgb", "red", "green", "blue", "argbFromXyz", "x", "y", "z", "clampInt", "min", "max", "input", "delinearized", "rgbComponent", "intFromLstar", "", "linearized", "lstarFromInt", "argb", "lstarFromY", "signum", "num", "xyzFromInt", "yFromInt", "yFromLstar", "material3_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCamUtils.android.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CamUtils.android.kt\nandroidx/compose/material3/internal/colorUtil/CamUtils\n+ 2 Color.kt\nandroidx/core/graphics/ColorKt\n*L\n1#1,290:1\n125#2:291\n133#2:292\n141#2:293\n125#2:294\n133#2:295\n141#2:296\n*S KotlinDebug\n*F\n+ 1 CamUtils.android.kt\nandroidx/compose/material3/internal/colorUtil/CamUtils\n*L\n240#1:291\n241#1:292\n242#1:293\n249#1:294\n250#1:295\n251#1:296\n*E\n"})
public final class CamUtils {
    @NotNull
    public static final CamUtils INSTANCE = new CamUtils();
    @NotNull
    private static final float[][] XYZ_TO_CAM16RGB;
    @NotNull
    private static final float[][] CAM16RGB_TO_XYZ;
    @NotNull
    private static final float[] WHITE_POINT_D65;
    @NotNull
    private static final double[][] SRGB_TO_XYZ;
    @NotNull
    private static final double[][] XYZ_TO_SRGB;
    public static final int $stable;

    private CamUtils() {
    }

    @NotNull
    public final float[][] getXYZ_TO_CAM16RGB() {
        return XYZ_TO_CAM16RGB;
    }

    @NotNull
    public final float[][] getCAM16RGB_TO_XYZ() {
        return CAM16RGB_TO_XYZ;
    }

    @NotNull
    public final float[] getWHITE_POINT_D65() {
        return WHITE_POINT_D65;
    }

    public final int signum(double num) {
        return num < 0.0 ? -1 : (num == 0.0 ? 0 : 1);
    }

    public final int argbFromLstar(double lstar) {
        double fy = (lstar + 16.0) / 116.0;
        double kappa = 903.2962962962963;
        double epsilon = 0.008856451679035631;
        boolean lExceedsEpsilonKappa = lstar > 8.0;
        double y = lExceedsEpsilonKappa ? fy * fy * fy : lstar / kappa;
        boolean cubeExceedEpsilon = fy * fy * fy > epsilon;
        double x = cubeExceedEpsilon ? fy * fy * fy : lstar / kappa;
        double z = cubeExceedEpsilon ? fy * fy * fy : lstar / kappa;
        float[] whitePoint = WHITE_POINT_D65;
        return this.argbFromXyz(x * (double)whitePoint[0], y * (double)whitePoint[1], z * (double)whitePoint[2]);
    }

    private final int argbFromXyz(double x, double y, double z) {
        double[][] matrix = XYZ_TO_SRGB;
        double linearR = matrix[0][0] * x + matrix[0][1] * y + matrix[0][2] * z;
        double linearG = matrix[1][0] * x + matrix[1][1] * y + matrix[1][2] * z;
        double linearB = matrix[2][0] * x + matrix[2][1] * y + matrix[2][2] * z;
        int r = this.delinearized(linearR);
        int g = this.delinearized(linearG);
        int b = this.delinearized(linearB);
        return this.argbFromRgb(r, g, b);
    }

    public final int argbFromLinrgbComponents(double r, double g, double b) {
        return this.argbFromRgb(this.delinearized(r), this.delinearized(g), this.delinearized(b));
    }

    private final int delinearized(double rgbComponent) {
        double normalized = rgbComponent / 100.0;
        double delinearized = normalized <= 0.0031308 ? normalized * 12.92 : 1.055 * Math.pow(normalized, 0.4166666666666667) - 0.055;
        return this.clampInt(0, 255, (int)Math.round(delinearized * 255.0));
    }

    private final int clampInt(int min, int max, int input) {
        if (input < min) {
            return min;
        }
        if (input > max) {
            return max;
        }
        return input;
    }

    private final int argbFromRgb(int red, int green, int blue) {
        return 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public final int intFromLstar(float lstar) {
        float fy;
        if (lstar < 1.0f) {
            return -16777216;
        }
        if (lstar > 99.0f) {
            return -1;
        }
        float fz = fy = (lstar + 16.0f) / 116.0f;
        float kappa = 903.2963f;
        float epsilon = 0.008856452f;
        boolean lExceedsEpsilonKappa = lstar > 8.0f;
        float yT = lExceedsEpsilonKappa ? fy * fy * fy : lstar / kappa;
        boolean cubeExceedEpsilon = fy * fy * fy > epsilon;
        float xT = cubeExceedEpsilon ? fy * fy * fy : (116.0f * fy - 16.0f) / kappa;
        float zT = cubeExceedEpsilon ? fz * fz * fz : (116.0f * fy - 16.0f) / kappa;
        return ColorUtils.XYZToColor((double)(xT * WHITE_POINT_D65[0]), (double)(yT * WHITE_POINT_D65[1]), (double)(zT * WHITE_POINT_D65[2]));
    }

    public final float lstarFromInt(int argb) {
        return this.lstarFromY(this.yFromInt(argb));
    }

    private final float lstarFromY(float y) {
        float yPrime = y;
        yPrime /= 100.0f;
        float e = 0.008856452f;
        float yIntermediate = 0.0f;
        if (yPrime <= e) {
            return 903.2963f * yPrime;
        }
        yIntermediate = (float)Math.cbrt(yPrime);
        return 116.0f * yIntermediate - 16.0f;
    }

    private final float yFromInt(int argb) {
        int $this$red$iv = argb;
        boolean $i$f$getRed = false;
        float r = this.linearized($this$red$iv >> 16 & 0xFF);
        int $this$green$iv = argb;
        boolean $i$f$getGreen = false;
        float g = this.linearized($this$green$iv >> 8 & 0xFF);
        int $this$blue$iv = argb;
        boolean $i$f$getBlue = false;
        float b = this.linearized($this$blue$iv & 0xFF);
        double[][] matrix = SRGB_TO_XYZ;
        double y = (double)r * matrix[1][0] + (double)g * matrix[1][1] + (double)b * matrix[1][2];
        return (float)y;
    }

    @NotNull
    public final float[] xyzFromInt(int argb) {
        int $this$red$iv = argb;
        boolean $i$f$getRed = false;
        float r = this.linearized($this$red$iv >> 16 & 0xFF);
        int $this$green$iv = argb;
        boolean $i$f$getGreen = false;
        float g = this.linearized($this$green$iv >> 8 & 0xFF);
        int $this$blue$iv = argb;
        boolean $i$f$getBlue = false;
        float b = this.linearized($this$blue$iv & 0xFF);
        double[][] matrix = SRGB_TO_XYZ;
        double x = (double)r * matrix[0][0] + (double)g * matrix[0][1] + (double)b * matrix[0][2];
        double y = (double)r * matrix[1][0] + (double)g * matrix[1][1] + (double)b * matrix[1][2];
        double z = (double)r * matrix[2][0] + (double)g * matrix[2][1] + (double)b * matrix[2][2];
        float[] fArray = new float[]{(float)x, (float)y, (float)z};
        return fArray;
    }

    public final double yFromLstar(double lstar) {
        double ke = 8.0;
        return lstar > ke ? Math.pow((lstar + 16.0) / 116.0, 3.0) * 100.0 : lstar / 903.2962962962963 * 100.0;
    }

    private final float linearized(int rgbComponent) {
        float normalized = (float)rgbComponent / 255.0f;
        return normalized <= 0.04045f ? normalized / 12.92f * 100.0f : (float)Math.pow((normalized + 0.055f) / 1.055f, 2.4f) * 100.0f;
    }

    static {
        Object object = new float[3][];
        Object[] objectArray = new float[]{0.401288f, 0.650173f, -0.051461f};
        object[0] = objectArray;
        objectArray = new float[]{-0.250268f, 1.204414f, 0.045854f};
        object[1] = objectArray;
        objectArray = new float[]{-0.002079f, 0.048952f, 0.953127f};
        object[2] = objectArray;
        XYZ_TO_CAM16RGB = object;
        object = new float[3][];
        objectArray = new float[]{1.8620678f, -1.0112547f, 0.14918678f};
        object[0] = objectArray;
        objectArray = new float[]{0.38752654f, 0.62144744f, -0.00897398f};
        object[1] = objectArray;
        objectArray = new float[]{-0.0158415f, -0.03412294f, 1.0499644f};
        object[2] = objectArray;
        CAM16RGB_TO_XYZ = object;
        object = new float[3];
        object[0] = (float[])95.047f;
        object[1] = (float[])100.0f;
        object[2] = (float[])108.883f;
        WHITE_POINT_D65 = (float[])object;
        object = new double[3][];
        objectArray = new double[3];
        objectArray[0] = (float)0.41233895;
        objectArray[1] = (float)0.35762064;
        objectArray[2] = (float)0.18051042;
        object[0] = objectArray;
        objectArray = new double[3];
        objectArray[0] = (float)0.2126;
        objectArray[1] = (float)0.7152;
        objectArray[2] = (float)0.0722;
        object[1] = objectArray;
        objectArray = new double[3];
        objectArray[0] = (float)0.01932141;
        objectArray[1] = (float)0.11916382;
        objectArray[2] = (float)0.95034478;
        object[2] = objectArray;
        SRGB_TO_XYZ = object;
        object = new double[3][];
        objectArray = new double[3];
        objectArray[0] = (float)3.2413774792388685;
        objectArray[1] = (float)-1.5376652402851851;
        objectArray[2] = (float)-0.49885366846268053;
        object[0] = objectArray;
        objectArray = new double[3];
        objectArray[0] = (float)-0.9691452513005321;
        objectArray[1] = (float)1.8758853451067872;
        objectArray[2] = (float)0.04156585616912061;
        object[1] = objectArray;
        objectArray = new double[3];
        objectArray[0] = (float)0.05562093689691305;
        objectArray[1] = (float)-0.20395524564742123;
        objectArray[2] = (float)1.0571799111220335;
        object[2] = objectArray;
        XYZ_TO_SRGB = object;
        $stable = 8;
    }
}

